/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.AbstractDistributedRule;

public class SharedCountersRule
extends AbstractDistributedRule {
    private static volatile Map<Serializable, AtomicInteger> counters;
    private final List<Serializable> idsToInitInBefore = new ArrayList<Serializable>();

    public static Builder builder() {
        return new Builder();
    }

    public SharedCountersRule() {
        this(new Builder());
    }

    SharedCountersRule(Builder builder) {
        this.idsToInitInBefore.addAll(builder.ids);
    }

    @Override
    protected void before() {
        this.invoker().invokeInEveryVMAndController(() -> {
            counters = new ConcurrentHashMap<Serializable, AtomicInteger>();
        });
        for (Serializable id : this.idsToInitInBefore) {
            this.invoker().invokeInEveryVMAndController(() -> this.initialize(id));
        }
        this.idsToInitInBefore.clear();
    }

    @Override
    protected void after() {
        this.invoker().invokeInEveryVMAndController(() -> {
            counters = null;
        });
    }

    public SharedCountersRule initialize(Serializable id) {
        AtomicInteger value = new AtomicInteger();
        this.invoker().invokeInEveryVMAndController(() -> counters.putIfAbsent(id, value));
        return this;
    }

    public AtomicInteger reference(Serializable id) {
        return counters.get(id);
    }

    public SharedCountersRule increment(Serializable id) {
        counters.get(id).incrementAndGet();
        return this;
    }

    public SharedCountersRule increment(Serializable id, int delta) {
        counters.get(id).addAndGet(delta);
        return this;
    }

    public SharedCountersRule decrement(Serializable id) {
        counters.get(id).decrementAndGet();
        return this;
    }

    public SharedCountersRule decrement(Serializable id, int delta) {
        counters.get(id).addAndGet(-delta);
        return this;
    }

    public int getTotal(Serializable id) {
        int total = counters.get(id).get();
        for (VM vm : VM.getAllVMs()) {
            total += ((Integer)vm.invoke(() -> counters.get(id).get())).intValue();
        }
        return total;
    }

    public int getLocal(Serializable id) {
        return counters.get(id).get();
    }

    public static class Builder {
        private final List<Serializable> ids = new ArrayList<Serializable>();

        public Builder withId(Serializable id) {
            this.ids.add(id);
            return this;
        }

        public SharedCountersRule build() {
            return new SharedCountersRule(this);
        }
    }
}

