/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.templates;

import java.security.Principal;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.LogWriter;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.Authenticator;
import org.apache.geode.security.templates.UsernamePrincipal;

public class SimpleAuthenticator
implements Authenticator {
    public void init(Properties securityProps, LogWriter systemLogger, LogWriter securityLogger) throws AuthenticationFailedException {
    }

    public static Authenticator create() {
        return new SimpleAuthenticator();
    }

    public Principal authenticate(Properties props, DistributedMember member) throws AuthenticationFailedException {
        String username = props.getProperty("security-username");
        String password = props.getProperty("security-password");
        if (StringUtils.isNotBlank((String)username) && !username.equals(password)) {
            throw new AuthenticationFailedException("SimpleAuthenticator expects username to match password.");
        }
        return new UsernamePrincipal(username);
    }

    public void close() {
    }
}

