/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.IOException;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.FetchKeysMessage;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class PartitionedRegionGetSomeKeys {
    private static final Logger logger = LogService.getLogger();

    public static Set<?> getSomeKeys(PartitionedRegion partitionedRegion, Random random) throws IOException, ClassNotFoundException {
        Set bucketIdSet = partitionedRegion.getRegionAdvisor().getBucketSet();
        if (bucketIdSet != null && !bucketIdSet.isEmpty()) {
            Object[] bucketIds = bucketIdSet.toArray();
            Integer bucketId = null;
            for (int i = 0; i < bucketIds.length; ++i) {
                try {
                    Set someKeys;
                    InternalDistributedMember member;
                    int whichBucket = random.nextInt(bucketIds.length);
                    if (whichBucket >= bucketIds.length) {
                        whichBucket = bucketIds.length - 1;
                    }
                    if ((member = partitionedRegion.getNodeForBucketRead((bucketId = (Integer)bucketIds[whichBucket]).intValue())) == null) continue;
                    if (member.equals((Object)partitionedRegion.getMyId())) {
                        someKeys = partitionedRegion.getDataStore().handleRemoteGetKeys(bucketId, 1, (Object)".*", false);
                    } else {
                        FetchKeysMessage.FetchKeysResponse fetchKeysResponse = FetchKeysMessage.send((InternalDistributedMember)member, (PartitionedRegion)partitionedRegion, (Integer)bucketId, (boolean)false);
                        someKeys = fetchKeysResponse.waitForKeys();
                    }
                    if (someKeys == null || someKeys.isEmpty()) continue;
                    return someKeys;
                }
                catch (ForceReattemptException movinOn) {
                    partitionedRegion.checkReadiness();
                    logger.debug("Test hook getSomeKeys caught a ForceReattemptException for bucketId={}{}{}. Moving on to another bucket", (Object)partitionedRegion.getPRId(), (Object)":", (Object)bucketId, (Object)movinOn);
                    continue;
                }
                catch (PRLocallyDestroyedException ignore) {
                    logger.debug("getSomeKeys: Encountered PRLocallyDestroyedException");
                    partitionedRegion.checkReadiness();
                }
            }
        }
        return Collections.emptySet();
    }
}

