/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms;

import org.apache.geode.CancelException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.MembershipManager;
import org.apache.geode.distributed.internal.membership.MembershipTestHook;
import org.apache.geode.distributed.internal.membership.gms.interfaces.Manager;
import org.apache.geode.distributed.internal.membership.gms.mgr.GMSMembershipManager;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.WaitCriterion;
import org.awaitility.core.ThrowingRunnable;

public class MembershipManagerHelper {
    public static MembershipManager getMembershipManager(DistributedSystem sys) {
        InternalDistributedSystem isys = (InternalDistributedSystem)sys;
        ClusterDistributionManager dm = (ClusterDistributionManager)isys.getDM();
        return dm.getMembershipManager();
    }

    public static void beSickMember(DistributedSystem sys) {
        ((Manager)MembershipManagerHelper.getMembershipManager(sys)).beSick();
    }

    public static void playDead(DistributedSystem sys) {
        try {
            ((Manager)MembershipManagerHelper.getMembershipManager(sys)).playDead();
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    public static DistributedMember getCoordinator(DistributedSystem sys) {
        return ((Manager)MembershipManagerHelper.getMembershipManager(sys)).getCoordinator();
    }

    public static DistributedMember getLeadMember(DistributedSystem sys) {
        return ((Manager)MembershipManagerHelper.getMembershipManager(sys)).getLeadMember();
    }

    public static void addTestHook(DistributedSystem sys, MembershipTestHook hook) {
        MembershipManagerHelper.getMembershipManager(sys).registerTestHook(hook);
    }

    public static void removeTestHook(DistributedSystem sys, MembershipTestHook hook) {
        MembershipManagerHelper.getMembershipManager(sys).unregisterTestHook(hook);
    }

    public static void addSurpriseMember(DistributedSystem sys, DistributedMember mbr, long birthTime) {
        ((Manager)MembershipManagerHelper.getMembershipManager(sys)).addSurpriseMemberForTesting(mbr, birthTime);
    }

    public static void inhibitForcedDisconnectLogging(boolean b) {
        GMSMembershipManager.inhibitForcedDisconnectLogging((boolean)b);
    }

    public static void waitForMemberDeparture(final DistributedSystem sys, final DistributedMember member, final long timeout) {
        WaitCriterion ev = new WaitCriterion(){

            @Override
            public boolean done() {
                return !MembershipManagerHelper.getMembershipManager(sys).getView().contains(member);
            }

            @Override
            public String description() {
                return "Waited over " + timeout + " ms for " + member + " to depart, but it didn't";
            }
        };
        GeodeAwaitility.await().untilAsserted((ThrowingRunnable)ev);
    }

    public static void crashDistributedSystem(DistributedSystem msys) {
        msys.getLogWriter().info("crashing distributed system: " + msys);
        GMSMembershipManager mgr = (GMSMembershipManager)MembershipManagerHelper.getMembershipManager(msys);
        mgr.saveCacheXmlForReconnect(false);
        MembershipManagerHelper.inhibitForcedDisconnectLogging(true);
        MembershipManagerHelper.beSickMember(msys);
        MembershipManagerHelper.playDead(msys);
        mgr.forceDisconnect("for testing");
        GeodeAwaitility.await().until(() -> !msys.isConnected());
        MembershipManagerHelper.inhibitForcedDisconnectLogging(false);
    }
}

