/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.MethExecutorResult;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.geode.SystemFailure;

public class MethExecutor {
    public static Method getMethod(Class c, String methodName, Class[] paramTypes) throws NoSuchMethodException {
        StringBuffer sb;
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        for (Class q = c; q != null; q = q.getSuperclass()) {
            Method[] methods = q.getDeclaredMethods();
            block1: for (int i = 0; i < methods.length; ++i) {
                Class<?>[] argTypes;
                Method m = methods[i];
                if (!m.getName().equals(methodName) || (argTypes = m.getParameterTypes()).length != paramTypes.length) continue;
                for (int j = 0; j < argTypes.length; ++j) {
                    if (paramTypes[j] == null) {
                        if (!argTypes[j].isPrimitive()) continue;
                        continue block1;
                    }
                    if (argTypes[j].isAssignableFrom(paramTypes[j])) continue;
                    Class<?> argType = argTypes[j];
                    Class paramType = paramTypes[j];
                    if (!(argType.isPrimitive() && (argType.equals(Boolean.TYPE) && paramType.equals(Boolean.class) || argType.equals(Short.TYPE) && paramType.equals(Short.class) || argType.equals(Integer.TYPE) && paramType.equals(Integer.class) || argType.equals(Long.TYPE) && paramType.equals(Long.class) || argType.equals(Float.TYPE) && paramType.equals(Float.class) || argType.equals(Double.TYPE) && paramType.equals(Double.class) || argType.equals(Character.TYPE) && paramType.equals(Character.class) || argType.equals(Byte.TYPE) && paramType.equals(Byte.class)))) continue block1;
                }
                matchingMethods.add(m);
            }
            if (matchingMethods.size() > 0) break;
        }
        if (matchingMethods.isEmpty()) {
            sb = new StringBuffer();
            sb.append("Could not find method ");
            sb.append(methodName);
            sb.append(" with ");
            sb.append(paramTypes.length);
            sb.append(" parameters [");
            for (int i = 0; i < paramTypes.length; ++i) {
                String name = paramTypes[i] == null ? null : paramTypes[i].getName();
                sb.append(name);
                if (i >= paramTypes.length - 1) continue;
                sb.append(", ");
            }
            sb.append("] in class ");
            sb.append(c.getName());
            throw new NoSuchMethodException(sb.toString());
        }
        if (matchingMethods.size() > 1) {
            sb = new StringBuffer();
            sb.append("Method is ambiguous ");
            sb.append(methodName);
            sb.append(" with ");
            sb.append(paramTypes.length);
            sb.append(" parameters [");
            for (int i = 0; i < paramTypes.length; ++i) {
                String name = paramTypes[i] == null ? null : paramTypes[i].getName();
                sb.append(name);
                if (i >= paramTypes.length - 1) continue;
                sb.append(", ");
            }
            sb.append("] in class ");
            sb.append(c.getName());
            sb.append(" methods=" + matchingMethods);
            throw new NoSuchMethodException(sb.toString());
        }
        return (Method)matchingMethods.get(0);
    }

    public static MethExecutorResult execute(String receiver, String selector) {
        return MethExecutor.execute(receiver, selector, null);
    }

    public static MethExecutorResult execute(String receiver, String selector, Object[] args) {
        try {
            Class<?> receiverClass = Class.forName(receiver);
            Object res = null;
            try {
                Class[] paramTypes;
                if (args == null) {
                    paramTypes = new Class[]{};
                } else {
                    paramTypes = new Class[args.length];
                    for (int i = 0; i < args.length; ++i) {
                        paramTypes[i] = args[i] == null ? null : args[i].getClass();
                    }
                }
                Method theMethod = MethExecutor.getMethod(receiverClass, selector, paramTypes);
                theMethod.setAccessible(true);
                res = theMethod.invoke(receiverClass, args);
                return new MethExecutorResult(res);
            }
            catch (InvocationTargetException invTargEx) {
                Throwable targEx = invTargEx.getTargetException();
                if (targEx == null) {
                    return new MethExecutorResult(res);
                }
                return new MethExecutorResult(targEx);
            }
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            return new MethExecutorResult(t);
        }
    }

    public static MethExecutorResult executeObject(Object target, String selector) {
        return MethExecutor.executeObject(target, selector, null);
    }

    public static MethExecutorResult executeObject(Object target, String selector, Object[] args) {
        try {
            Class<?> receiverClass = target.getClass();
            Object res = null;
            try {
                Class[] paramTypes;
                if (args == null) {
                    paramTypes = new Class[]{};
                } else {
                    paramTypes = new Class[args.length];
                    for (int i = 0; i < args.length; ++i) {
                        paramTypes[i] = args[i] == null ? Object.class : args[i].getClass();
                    }
                }
                Method theMethod = MethExecutor.getMethod(receiverClass, selector, paramTypes);
                theMethod.setAccessible(true);
                res = theMethod.invoke(target, args);
                return new MethExecutorResult(res);
            }
            catch (InvocationTargetException invTargEx) {
                Throwable targEx = invTargEx.getTargetException();
                if (targEx == null) {
                    return new MethExecutorResult(res);
                }
                return new MethExecutorResult(targEx);
            }
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            return new MethExecutorResult(t);
        }
    }

    public static MethExecutorResult executeInstance(String receiver, String selector) {
        try {
            Class<?> receiverClass = Class.forName(receiver);
            Object target = receiverClass.newInstance();
            Object res = null;
            try {
                Method theMethod = MethExecutor.getMethod(receiverClass, selector, new Class[0]);
                res = theMethod.invoke(target, new Object[0]);
                return new MethExecutorResult(res);
            }
            catch (InvocationTargetException invTargEx) {
                Throwable targEx = invTargEx.getTargetException();
                if (targEx == null) {
                    return new MethExecutorResult(res);
                }
                return new MethExecutorResult(targEx);
            }
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            return new MethExecutorResult(t);
        }
    }

    public static MethExecutorResult executeInstance(String receiver, String selector, Class[] types, Object[] args) {
        try {
            Class<?> receiverClass = Class.forName(receiver);
            Constructor<?> init = receiverClass.getDeclaredConstructor(new Class[0]);
            init.setAccessible(true);
            Object target = init.newInstance(new Object[0]);
            Object res = null;
            try {
                Method theMethod = MethExecutor.getMethod(receiverClass, selector, types);
                res = theMethod.invoke(target, args);
                return new MethExecutorResult(res);
            }
            catch (InvocationTargetException invTargEx) {
                Throwable targEx = invTargEx.getTargetException();
                if (targEx == null) {
                    return new MethExecutorResult(res);
                }
                return new MethExecutorResult(targEx);
            }
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            return new MethExecutorResult(t);
        }
    }

    public static String testMethod1() {
        return "The result is: " + System.currentTimeMillis();
    }

    public static String testMethod2() {
        throw new ArrayIndexOutOfBoundsException("frip");
    }

    public static void main(String[] args) {
        MethExecutorResult result = null;
        result = MethExecutor.execute("hydra.MethExecutor", "testMethod1");
        System.out.println(result.toString());
        result = MethExecutor.execute("hydra.MethExecutor", "testMethod2");
        System.out.println(result.toString());
    }
}

