/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.client.NoAvailableServersException;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.ServerRefusedConnectionException;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.ProxyCache;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache30.ClientServerTestCase;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.Version;
import org.apache.geode.pdx.PdxReader;
import org.apache.geode.pdx.PdxSerializable;
import org.apache.geode.pdx.PdxWriter;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.templates.UsernamePrincipal;
import org.apache.geode.test.dunit.Assert;
import org.apache.geode.test.dunit.DistributedTestUtils;
import org.apache.geode.test.dunit.LogWriterUtils;
import org.apache.geode.test.dunit.NetworkUtils;
import org.apache.geode.test.dunit.internal.JUnit4DistributedTestCase;
import org.awaitility.Awaitility;

@Deprecated
public class SecurityTestUtils {
    private final JUnit4DistributedTestCase distributedTestCase = new JUnit4DistributedTestCase(){};
    protected static final int NO_EXCEPTION = 0;
    protected static final int AUTHREQ_EXCEPTION = 1;
    protected static final int AUTHFAIL_EXCEPTION = 2;
    protected static final int CONNREFUSED_EXCEPTION = 3;
    protected static final int NOTAUTHZ_EXCEPTION = 4;
    protected static final int OTHER_EXCEPTION = 5;
    protected static final int NO_AVAILABLE_SERVERS = 6;
    protected static final int SECURITY_EXCEPTION = 7;
    protected static final int NOFORCE_AUTHREQ_EXCEPTION = 16;
    protected static final String REGION_NAME = "AuthRegion";
    protected static final String[] KEYS = new String[]{"key1", "key2", "key3", "key4", "key5", "key6", "key7", "key8"};
    protected static final String[] VALUES = new String[]{"value1", "value2", "value3", "value4", "value5", "value6", "value7", "value8"};
    protected static final String[] NVALUES = new String[]{"nvalue1", "nvalue2", "nvalue3", "nvalue4", "nvalue5", "nvalue6", "nvalue7", "nvalue8"};
    private static final int NUMBER_OF_USERS = 1;
    private static String[] ignoredExceptions = null;
    private static Locator locator = null;
    private static Cache cache = null;
    private static Properties currentJavaProps = null;
    private static Pool pool = null;
    private static boolean multiUserAuthMode = false;
    private static ProxyCache[] proxyCaches = new ProxyCache[1];
    private static Region regionRef = null;

    private static void addIgnoredExceptions(String[] expectedExceptions) {
        if (expectedExceptions != null) {
            for (int index = 0; index < expectedExceptions.length; ++index) {
                LogWriterUtils.getLogWriter().info("<ExpectedException action=add>" + expectedExceptions[index] + "</ExpectedException>");
            }
        }
    }

    private static void removeExpectedExceptions(String[] expectedExceptions) {
        if (expectedExceptions != null) {
            for (int index = 0; index < expectedExceptions.length; ++index) {
                LogWriterUtils.getLogWriter().info("<ExpectedException action=remove>" + expectedExceptions[index] + "</ExpectedException>");
            }
        }
    }

    protected static void setJavaProps(Properties javaProps) {
        SecurityTestUtils.removeJavaProperties(currentJavaProps);
        SecurityTestUtils.addJavaProperties(javaProps);
        currentJavaProps = javaProps;
    }

    protected static ProxyCache getProxyCaches(int index) {
        return proxyCaches[index];
    }

    protected static void initDynamicRegionFactory() {
        DynamicRegionFactory.get().open(new DynamicRegionFactory.Config(null, null, false, true));
    }

    protected static Properties concatProperties(Properties[] propsList) {
        Properties props = new Properties();
        for (int index = 0; index < propsList.length; ++index) {
            if (propsList[index] == null) continue;
            props.putAll((Map<?, ?>)propsList[index]);
        }
        return props;
    }

    protected static void registerExpectedExceptions(String[] expectedExceptions) {
        ignoredExceptions = expectedExceptions;
    }

    protected static int createCacheServer(String authenticatorFactoryMethodName) {
        Properties authProps = new Properties();
        authProps.setProperty("security-client-authenticator", authenticatorFactoryMethodName);
        return SecurityTestUtils.createCacheServer(authProps, null, 0, false, 0);
    }

    protected static int createCacheServer(Properties authProps, Properties javaProps, int serverPort, int expectedResult) {
        return SecurityTestUtils.createCacheServer(authProps, javaProps, serverPort, false, expectedResult);
    }

    protected static int createCacheServer(Properties authProps, Properties javaProps, int serverPort, boolean setupDynamicRegionFactory, int expectedResult) {
        if (authProps == null) {
            authProps = new Properties();
        }
        authProps.setProperty("mcast-port", "0");
        authProps.setProperty("locators", "localhost[" + DistributedTestUtils.getDUnitLocatorPort() + "]");
        authProps.setProperty("security-log-level", "finest");
        LogWriterUtils.getLogWriter().info("Set the server properties to: " + authProps);
        LogWriterUtils.getLogWriter().info("Set the java properties to: " + javaProps);
        SecurityTestUtils tmpInstance = new SecurityTestUtils();
        try {
            tmpInstance.createSystem(authProps, javaProps);
        }
        catch (AuthenticationRequiredException ex) {
            if (expectedResult == 1) {
                LogWriterUtils.getLogWriter().info("Got expected exception when starting peer: " + (Object)((Object)ex));
                return 0;
            }
            Assert.fail("Got unexpected exception when starting peer", ex);
        }
        catch (AuthenticationFailedException ex) {
            if (expectedResult == 2) {
                LogWriterUtils.getLogWriter().info("Got expected exception when starting peer: " + (Object)((Object)ex));
                return 0;
            }
            Assert.fail("Got unexpected exception when starting peer", ex);
        }
        catch (Exception ex) {
            Assert.fail("Got unexpected exception when starting peer", ex);
        }
        if (setupDynamicRegionFactory) {
            SecurityTestUtils.initDynamicRegionFactory();
        }
        tmpInstance.openCache();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(REGION_NAME, attrs);
        int port = serverPort <= 0 ? 0 : serverPort;
        CacheServer server1 = cache.addCacheServer();
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        try {
            server1.start();
        }
        catch (AuthenticationRequiredException ex) {
            if (expectedResult == 1) {
                LogWriterUtils.getLogWriter().info("Got expected exception when starting server: " + (Object)((Object)ex));
                return 0;
            }
            Assert.fail("Got unexpected exception when starting server", ex);
        }
        catch (Exception ex) {
            Assert.fail("Got unexpected exception when starting server", ex);
        }
        return server1.getPort();
    }

    protected static void createCacheClient(String authInitModule, Properties authProps, Properties javaProps, int[] ports, int numConnections, int expectedResult) {
        SecurityTestUtils.createCacheClient(authInitModule, authProps, javaProps, ports, numConnections, false, expectedResult);
    }

    protected static void createCacheClient(String authInitModule, Properties authProps, Properties javaProps, int[] ports, int numConnections, boolean multiUserMode, int expectedResult) {
        SecurityTestUtils.createCacheClient(authInitModule, authProps, javaProps, ports, numConnections, false, multiUserMode, expectedResult);
    }

    protected static void createCacheClientWithDynamicRegion(String authInitModule, Properties authProps, Properties javaProps, int[] ports, int numConnections, boolean setupDynamicRegionFactory, int expectedResult) {
        SecurityTestUtils.createCacheClient(authInitModule, authProps, javaProps, ports, numConnections, setupDynamicRegionFactory, false, expectedResult);
    }

    protected static void createCacheClientWithDynamicRegion(String authInitModule, Properties authProps, Properties javaProps, int numConnections, boolean setupDynamicRegionFactory, int expectedResult) {
        SecurityTestUtils.createCacheClient(authInitModule, authProps, javaProps, new int[0], numConnections, setupDynamicRegionFactory, false, expectedResult);
    }

    protected static void createCacheClient(String authInitModule, Properties authProps, Properties javaProps, int[] ports, int numConnections, boolean setupDynamicRegionFactory, boolean multiUserMode, int expectedResult) {
        SecurityTestUtils.createCacheClient(authInitModule, authProps, javaProps, ports, numConnections, setupDynamicRegionFactory, multiUserMode, true, expectedResult);
    }

    protected static void createCacheClient(String authInitModule, Properties authProps, Properties javaProps, int[] ports, int numConnections, boolean setupDynamicRegionFactory, boolean multiUserMode, boolean subscriptionEnabled, int expectedResult) {
        multiUserAuthMode = multiUserMode;
        if (authProps == null) {
            authProps = new Properties();
        }
        authProps.setProperty("mcast-port", "0");
        authProps.setProperty("locators", "");
        authProps.setProperty("security-log-level", "finest");
        if (Version.CURRENT_ORDINAL >= 75) {
            authProps.put("serializable-object-filter", UsernamePrincipal.class.getName());
        }
        if (authInitModule != null) {
            authProps.setProperty("security-client-auth-init", authInitModule);
        }
        SecurityTestUtils tmpInstance = new SecurityTestUtils();
        tmpInstance.createSystem(authProps, javaProps);
        AttributesFactory factory = new AttributesFactory();
        int[] portsI = new int[ports.length];
        for (int z = 0; z < ports.length; ++z) {
            portsI[z] = ports[z];
        }
        try {
            PoolFactory poolFactory = PoolManager.createFactory();
            poolFactory.setRetryAttempts(200);
            if (multiUserAuthMode) {
                poolFactory.setMultiuserAuthentication(multiUserAuthMode);
            }
            pool = ClientServerTestCase.configureConnectionPoolWithNameAndFactory(factory, NetworkUtils.getIPLiteral(), portsI, subscriptionEnabled, 0, numConnections, null, null, poolFactory);
            if (setupDynamicRegionFactory) {
                SecurityTestUtils.initClientDynamicRegionFactory(pool.getName());
            }
            tmpInstance.openCache();
            try {
                LogWriterUtils.getLogWriter().info("multi-user mode " + multiUserAuthMode);
                SecurityTestUtils.proxyCaches[0] = (ProxyCache)((PoolImpl)pool).createAuthenticatedCacheView(authProps);
                if (!multiUserAuthMode) {
                    Assert.fail((String)"Expected a UnsupportedOperationException but got none in single-user mode");
                }
            }
            catch (UnsupportedOperationException uoe) {
                if (!multiUserAuthMode) {
                    LogWriterUtils.getLogWriter().info("Got expected UnsupportedOperationException in single-user mode");
                }
                Assert.fail("Got unexpected exception in multi-user mode ", uoe);
            }
            factory.setScope(Scope.LOCAL);
            if (multiUserAuthMode) {
                factory.setDataPolicy(DataPolicy.EMPTY);
            }
            RegionAttributes attrs = factory.create();
            cache.createRegionFactory(attrs).create(REGION_NAME);
        }
        catch (AuthenticationRequiredException ex) {
            if (expectedResult == 1 || expectedResult == 16) {
                LogWriterUtils.getLogWriter().info("Got expected exception when starting client: " + (Object)((Object)ex));
            } else {
                Assert.fail("Got unexpected exception when starting client", ex);
            }
        }
        catch (AuthenticationFailedException ex) {
            if (expectedResult == 2) {
                LogWriterUtils.getLogWriter().info("Got expected exception when starting client: " + (Object)((Object)ex));
            } else {
                Assert.fail("Got unexpected exception when starting client", ex);
            }
        }
        catch (ServerRefusedConnectionException ex) {
            if (expectedResult == 3) {
                LogWriterUtils.getLogWriter().info("Got expected exception when starting client: " + (Object)((Object)ex));
            } else {
                Assert.fail("Got unexpected exception when starting client", ex);
            }
        }
        catch (GemFireSecurityException ex) {
            if (expectedResult == 7) {
                LogWriterUtils.getLogWriter().info("Got expected exception when starting client: " + (Object)((Object)ex));
            } else {
                Assert.fail("Got unexpected exception when starting client", ex);
            }
        }
        catch (Exception ex) {
            Assert.fail("Got unexpected exception when starting client", ex);
        }
    }

    protected static void createCacheClientForMultiUserMode(int numOfUsers, String authInitModule, Properties[] authProps, Properties javaProps, int[] ports, int numConnections, boolean setupDynamicRegionFactory, int expectedResult) {
        SecurityTestUtils.createCacheClientForMultiUserMode(numOfUsers, authInitModule, authProps, javaProps, ports, numConnections, setupDynamicRegionFactory, null, expectedResult);
    }

    protected static void createCacheClientForMultiUserMode(int numOfUsers, String authInitModule, Properties[] authProps, Properties javaProps, int[] ports, int numConnections, boolean setupDynamicRegionFactory, String durableClientId, int expectedResult) {
        if (numOfUsers < 1) {
            Assert.fail((String)"Number of users cannot be less than one");
        }
        multiUserAuthMode = true;
        if (numOfUsers != authProps.length) {
            Assert.fail((String)("Number of authProps provided does not match with numOfUsers specified, " + authProps.length));
        }
        if (authProps[0] == null) {
            authProps[0] = new Properties();
        }
        authProps[0].setProperty("mcast-port", "0");
        authProps[0].setProperty("locators", "");
        authProps[0].setProperty("security-log-level", "finest");
        Properties props = new Properties();
        if (authInitModule != null) {
            authProps[0].setProperty("security-client-auth-init", authInitModule);
            props.setProperty("security-client-auth-init", authInitModule);
        }
        if (durableClientId != null) {
            props.setProperty("durable-client-id", durableClientId);
            props.setProperty("durable-client-timeout", String.valueOf(300));
        }
        if (Version.CURRENT.ordinal() >= 75) {
            props.put("serializable-object-filter", "org.apache.geode.security.templates.UsernamePrincipal");
        }
        SecurityTestUtils tmpInstance = new SecurityTestUtils();
        tmpInstance.createSystem(props, javaProps);
        AttributesFactory factory = new AttributesFactory();
        int[] portsI = new int[ports.length];
        for (int z = 0; z < ports.length; ++z) {
            portsI[z] = ports[z];
        }
        try {
            tmpInstance.openCache();
            PoolFactory poolFactory = PoolManager.createFactory();
            poolFactory.setRetryAttempts(200);
            poolFactory.setMultiuserAuthentication(multiUserAuthMode);
            poolFactory.setSubscriptionEnabled(true);
            pool = ClientServerTestCase.configureConnectionPoolWithNameAndFactory(factory, NetworkUtils.getIPLiteral(), portsI, true, 1, numConnections, null, null, poolFactory);
            if (setupDynamicRegionFactory) {
                SecurityTestUtils.initClientDynamicRegionFactory(pool.getName());
            }
            proxyCaches = new ProxyCache[numOfUsers];
            for (int i = 0; i < numOfUsers; ++i) {
                SecurityTestUtils.proxyCaches[i] = (ProxyCache)((PoolImpl)pool).createAuthenticatedCacheView(authProps[i]);
            }
            factory.setScope(Scope.LOCAL);
            factory.setDataPolicy(DataPolicy.EMPTY);
            RegionAttributes attrs = factory.create();
            cache.createRegion(REGION_NAME, attrs);
            if (expectedResult != 0 && expectedResult != 16 && !multiUserAuthMode) {
                Assert.fail((String)"Expected an exception when starting client");
            }
        }
        catch (AuthenticationRequiredException ex) {
            if (expectedResult == 1 || expectedResult == 16) {
                LogWriterUtils.getLogWriter().info("Got expected exception when starting client: " + (Object)((Object)ex));
            } else {
                Assert.fail("Got unexpected exception when starting client", ex);
            }
        }
        catch (AuthenticationFailedException ex) {
            if (expectedResult == 2) {
                LogWriterUtils.getLogWriter().info("Got expected exception when starting client: " + (Object)((Object)ex));
            } else {
                Assert.fail("Got unexpected exception when starting client", ex);
            }
        }
        catch (ServerRefusedConnectionException ex) {
            if (expectedResult == 3) {
                LogWriterUtils.getLogWriter().info("Got expected exception when starting client: " + (Object)((Object)ex));
            } else {
                Assert.fail("Got unexpected exception when starting client", ex);
            }
        }
        catch (Exception ex) {
            Assert.fail("Got unexpected exception when starting client", ex);
        }
    }

    protected static void createProxyCache(int[] userIndices, Properties[] props) {
        int j = 0;
        for (int i : userIndices) {
            SecurityTestUtils.proxyCaches[i] = (ProxyCache)((PoolImpl)pool).createAuthenticatedCacheView(props[j]);
            ++j;
        }
    }

    protected static void startLocator(String name, int port, Properties extraProps, Properties javaProps, String[] expectedExceptions) {
        try {
            Properties authProps = new Properties();
            if (extraProps != null) {
                authProps.putAll((Map<?, ?>)extraProps);
            }
            authProps.setProperty("mcast-port", "0");
            authProps.setProperty("locators", NetworkUtils.getIPLiteral() + "[" + port + "]");
            authProps.setProperty("enable-cluster-configuration", "false");
            SecurityTestUtils.clearStaticSSLContext();
            SecurityTestUtils.setJavaProps(javaProps);
            File logFile = new File(name + "-locator" + port + ".log");
            FileOutputStream logOut = new FileOutputStream(logFile);
            PrintStream logStream = new PrintStream(logOut);
            SecurityTestUtils.addIgnoredExceptions(expectedExceptions);
            logStream.flush();
            locator = Locator.startLocatorAndDS((int)port, (File)logFile, null, (Properties)authProps);
        }
        catch (IOException ex) {
            Assert.fail("While starting locator on port " + port, ex);
        }
    }

    protected static void stopLocator(int port, String[] expectedExceptions) {
        try {
            locator.stop();
            SecurityTestUtils.removeExpectedExceptions(expectedExceptions);
        }
        catch (Exception ex) {
            Assert.fail("While stopping locator on port " + port, ex);
        }
    }

    protected static Cache getCache() {
        return cache;
    }

    protected static Object getLocalValue(Region region, Object key) {
        Region.Entry entry = region.getEntry(key);
        if (entry != null) {
            try {
                return entry.getValue();
            }
            catch (EntryDestroyedException e) {
                return null;
            }
        }
        return null;
    }

    protected static void doProxyCacheClose() {
        for (int i = 0; i < proxyCaches.length; ++i) {
            proxyCaches[i].close();
        }
    }

    protected static void doPutAllP() throws Exception {
        Region region = SecurityTestUtils.getCache().getRegion(REGION_NAME);
        Assert.assertNotNull((Object)region);
        LinkedHashMap<String, Employee> map = new LinkedHashMap<String, Employee>();
        map.put("1010L", new Employee(1010L, "John", "Doe"));
        region.putAll(map);
    }

    protected static void doPuts(int num) {
        SecurityTestUtils.doPutsP(num, 0, false);
    }

    protected static void doPuts(int num, int expectedResult) {
        SecurityTestUtils.doPutsP(num, expectedResult, false);
    }

    protected static void verifySizeOnServer(int size) {
        SecurityTestUtils.verifySizeOnServer(size, 0);
    }

    protected static void verifyIsEmptyOnServer(boolean isEmpty) {
        SecurityTestUtils.verifyIsEmptyOnServer(isEmpty, 0);
    }

    protected static void doMultiUserPuts(int num, int numOfUsers, int[] expectedResults) {
        if (numOfUsers != expectedResults.length) {
            Assert.fail((String)("SecurityTestUtils.doMultiUserPuts(): numOfUsers = " + numOfUsers + ", but expected results " + expectedResults.length));
        }
        for (int i = 0; i < numOfUsers; ++i) {
            LogWriterUtils.getLogWriter().info("PUT: MultiUser# " + i);
            SecurityTestUtils.doPutsP(num, i, expectedResults[i], false);
        }
    }

    protected static void doGets(int num) {
        SecurityTestUtils.doGetsP(num, 0, false);
    }

    protected static void doGets(int num, int expectedResult) {
        SecurityTestUtils.doGetsP(num, expectedResult, false);
    }

    protected static void doMultiUserGetAll(int numOfUsers, int[] expectedResults) {
        SecurityTestUtils.doMultiUserGetAll(numOfUsers, expectedResults, false);
    }

    protected static void doMultiUserGetAll(int numOfUsers, int[] expectedResults, boolean useTX) {
        if (numOfUsers != expectedResults.length) {
            Assert.fail((String)("SecurityTestUtils.doMultiUserGetAll(): numOfUsers = " + numOfUsers + ", but expected results " + expectedResults.length));
        }
        for (int i = 0; i < numOfUsers; ++i) {
            LogWriterUtils.getLogWriter().info("GET_ALL" + (useTX ? " in TX" : "") + ": MultiUser# " + i);
            SecurityTestUtils.doGetAllP(i, expectedResults[i], useTX);
        }
    }

    protected static void doMultiUserGets(int num, int numOfUsers, int[] expectedResults) {
        if (numOfUsers != expectedResults.length) {
            Assert.fail((String)("SecurityTestUtils.doMultiUserGets(): numOfUsers = " + numOfUsers + ", but expected results " + expectedResults.length));
        }
        for (int i = 0; i < numOfUsers; ++i) {
            LogWriterUtils.getLogWriter().info("GET: MultiUser# " + i);
            SecurityTestUtils.doGetsP(num, i, expectedResults[i], false);
        }
    }

    protected static void doMultiUserRegionDestroys(int numOfUsers, int[] expectedResults) {
        if (numOfUsers != expectedResults.length) {
            Assert.fail((String)("SecurityTestUtils.doMultiUserRegionDestroys(): numOfUsers = " + numOfUsers + ", but expected results " + expectedResults.length));
        }
        for (int i = numOfUsers - 1; i >= 0; --i) {
            LogWriterUtils.getLogWriter().info("DESTROY: MultiUser# " + i);
            SecurityTestUtils.doRegionDestroysP(i, expectedResults[i]);
        }
    }

    protected static void doMultiUserDestroys(int num, int numOfUsers, int[] expectedResults) {
        if (numOfUsers != expectedResults.length) {
            Assert.fail((String)("SecurityTestUtils.doMultiUserDestroys(): numOfUsers = " + numOfUsers + ", but expected results " + expectedResults.length));
        }
        for (int i = 0; i < numOfUsers; ++i) {
            LogWriterUtils.getLogWriter().info("DESTROY: MultiUser# " + i);
            SecurityTestUtils.doDestroysP(num, i, expectedResults[i]);
        }
    }

    protected static void doMultiUserInvalidates(int num, int numOfUsers, int[] expectedResults) {
        if (numOfUsers != expectedResults.length) {
            Assert.fail((String)("SecurityTestUtils.doMultiUserInvalidates(): numOfUsers = " + numOfUsers + ", but expected results " + expectedResults.length));
        }
        for (int i = 0; i < numOfUsers; ++i) {
            LogWriterUtils.getLogWriter().info("INVALIDATE: MultiUser# " + i);
            SecurityTestUtils.doInvalidatesP(num, i, expectedResults[i]);
        }
    }

    protected static void doMultiUserContainsKeys(int num, int numOfUsers, int[] expectedResults, boolean[] results) {
        if (numOfUsers != expectedResults.length) {
            Assert.fail((String)("SecurityTestUtils.doMultiUserContainsKeys(): numOfUsers = " + numOfUsers + ", but #expected results " + expectedResults.length));
        }
        if (numOfUsers != results.length) {
            Assert.fail((String)("SecurityTestUtils.doMultiUserContainsKeys(): numOfUsers = " + numOfUsers + ", but #expected output " + results.length));
        }
        for (int i = 0; i < numOfUsers; ++i) {
            LogWriterUtils.getLogWriter().info("CONTAINS_KEY: MultiUser# " + i);
            SecurityTestUtils.doContainsKeysP(num, i, expectedResults[i], results[i]);
        }
    }

    protected static void doMultiUserQueries(int numOfUsers, int[] expectedResults, int valueSize) {
        if (numOfUsers != expectedResults.length) {
            Assert.fail((String)("SecurityTestUtils.doMultiUserQueries(): numOfUsers = " + numOfUsers + ", but #expected results " + expectedResults.length));
        }
        for (int i = 0; i < numOfUsers; ++i) {
            LogWriterUtils.getLogWriter().info("QUERY: MultiUser# " + i);
            SecurityTestUtils.doQueriesP(i, expectedResults[i], valueSize);
        }
    }

    protected static void doMultiUserFE(int numOfUsers, Function function, int[] expectedResults, boolean isFailOverCase) {
        int i;
        if (numOfUsers != expectedResults.length) {
            Assert.fail((String)("SecurityTestUtils.doMultiUserFE(): numOfUsers = " + numOfUsers + ", but #expected results " + expectedResults.length));
        }
        for (i = 0; i < numOfUsers; ++i) {
            LogWriterUtils.getLogWriter().info("FunctionExecute:onRegion MultiUser# " + i);
            SecurityTestUtils.doFunctionExecuteP(i, function, expectedResults[i], "region");
        }
        for (i = 0; i < numOfUsers; ++i) {
            LogWriterUtils.getLogWriter().info("FunctionExecute:onServer MultiUser# " + i);
            SecurityTestUtils.doFunctionExecuteP(i, function, expectedResults[i], "server");
        }
        if (!isFailOverCase) {
            for (i = 0; i < numOfUsers; ++i) {
                LogWriterUtils.getLogWriter().info("FunctionExecute:onServers MultiUser# " + i);
                SecurityTestUtils.doFunctionExecuteP(i, function, expectedResults[i], "servers");
            }
        }
    }

    protected static void doMultiUserQueryExecute(int numOfUsers, int[] expectedResults, int result) {
        if (numOfUsers != expectedResults.length) {
            Assert.fail((String)("SecurityTestUtils.doMultiUserFE(): numOfUsers = " + numOfUsers + ", but #expected results " + expectedResults.length));
        }
        for (int i = 0; i < numOfUsers; ++i) {
            LogWriterUtils.getLogWriter().info("QueryExecute: MultiUser# " + i);
            SecurityTestUtils.doQueryExecuteP(i, expectedResults[i], result);
        }
    }

    protected static void doLocalGets(int num) {
        SecurityTestUtils.doLocalGetsP(num, false);
    }

    protected static void doNPuts(int num) {
        SecurityTestUtils.doPutsP(num, 0, true);
    }

    protected static void doNPuts(int num, int expectedResult) {
        SecurityTestUtils.doPutsP(num, expectedResult, true);
    }

    protected static void doNGets(int num) {
        SecurityTestUtils.doGetsP(num, 0, true);
    }

    protected static void doNGets(int num, int expectedResult) {
        SecurityTestUtils.doGetsP(num, expectedResult, true);
    }

    protected static void doNLocalGets(int num) {
        SecurityTestUtils.doLocalGetsP(num, true);
    }

    protected static void doSimpleGet(String expectedResult) {
        if (regionRef != null) {
            try {
                regionRef.get((Object)"KEY");
                if (expectedResult != null && expectedResult.endsWith("Exception")) {
                    Assert.fail((String)("Expected " + expectedResult + " but found none in doSimpleGet()"));
                }
            }
            catch (Exception e) {
                if (!e.getClass().getSimpleName().endsWith(expectedResult)) {
                    Assert.fail((String)("Expected " + expectedResult + " but found " + e.getClass().getSimpleName() + " in doSimpleGet()"));
                }
                LogWriterUtils.getLogWriter().fine("Got expected " + e.getClass().getSimpleName() + " in doSimpleGet()");
            }
        }
    }

    protected static void doSimplePut(String expectedResult) {
        if (regionRef != null) {
            try {
                regionRef.put((Object)"KEY", (Object)"VALUE");
                if (expectedResult != null && expectedResult.endsWith("Exception")) {
                    Assert.fail((String)("Expected " + expectedResult + " but found none in doSimplePut()"));
                }
            }
            catch (Exception e) {
                if (!e.getClass().getSimpleName().endsWith(expectedResult)) {
                    Assert.fail("Expected " + expectedResult + " but found " + e.getClass().getSimpleName() + " in doSimplePut()", e);
                }
                LogWriterUtils.getLogWriter().fine("Got expected " + e.getClass().getSimpleName() + " in doSimplePut()");
            }
        }
    }

    protected static void clearStaticSSLContext() {
        ServerSocketFactory defaultServerFact = SSLServerSocketFactory.getDefault();
        Map<Field, Object> contextMap = SecurityTestUtils.getSSLFields(defaultServerFact, new Class[]{SSLContext.class, SSLContextSpi.class});
        SecurityTestUtils.makeNullSSLFields(defaultServerFact, contextMap);
        for (Object contextObj : contextMap.values()) {
            Map<Field, Object> contextObjsMap = SecurityTestUtils.getSSLFields(contextObj, new Class[]{TrustManager.class, KeyManager.class, TrustManager[].class, KeyManager[].class});
            SecurityTestUtils.makeNullSSLFields(contextObj, contextObjsMap);
        }
        SecurityTestUtils.makeNullStaticField(SSLServerSocketFactory.class);
        SocketFactory defaultFact = SSLSocketFactory.getDefault();
        contextMap = SecurityTestUtils.getSSLFields(defaultFact, new Class[]{SSLContext.class, SSLContextSpi.class});
        SecurityTestUtils.makeNullSSLFields(defaultFact, contextMap);
        for (Object contextObj : contextMap.values()) {
            Map<Field, Object> contextObjsMap = SecurityTestUtils.getSSLFields(contextObj, new Class[]{TrustManager.class, KeyManager.class, TrustManager[].class, KeyManager[].class});
            SecurityTestUtils.makeNullSSLFields(contextObj, contextObjsMap);
        }
        SecurityTestUtils.makeNullStaticField(SSLSocketFactory.class);
        SecurityTestUtils.makeNullStaticField(SSLContext.class);
    }

    protected static void closeCache() {
        SecurityTestUtils.removeExpectedExceptions(ignoredExceptions);
        if (cache != null && !cache.isClosed()) {
            DistributedSystem sys = cache.getDistributedSystem();
            cache.close();
            sys.disconnect();
            cache = null;
        }
        ClientServerTestCase.disconnectFromDS();
    }

    protected static void closeCache(Boolean keepAlive) {
        SecurityTestUtils.removeExpectedExceptions(ignoredExceptions);
        if (cache != null && !cache.isClosed()) {
            DistributedSystem sys = cache.getDistributedSystem();
            cache.close(keepAlive.booleanValue());
            sys.disconnect();
            cache = null;
        }
        ClientServerTestCase.disconnectFromDS();
    }

    private static void initClientDynamicRegionFactory(String poolName) {
        DynamicRegionFactory.get().open(new DynamicRegionFactory.Config(null, poolName, false, true));
    }

    private static void addJavaProperties(Properties javaProps) {
        if (javaProps != null) {
            for (Map.Entry<Object, Object> entry : javaProps.entrySet()) {
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private static void removeJavaProperties(Properties javaProps) {
        if (javaProps != null) {
            Properties props = System.getProperties();
            Iterator<Object> iter = javaProps.keySet().iterator();
            while (iter.hasNext()) {
                props.remove(iter.next());
            }
            System.setProperties(props);
        }
    }

    private static void verifySizeOnServer(int size, int expectedResult) {
        Region region = SecurityTestUtils.getRegion(0, expectedResult);
        try {
            int sizeOnServer = region.sizeOnServer();
            if (expectedResult != 0) {
                Assert.fail((String)"Expected a NotAuthorizedException while executing sizeOnServer");
            }
            Assert.assertEquals((long)size, (long)sizeOnServer);
        }
        catch (NoSuchMethodError sizeOnServer) {
        }
        catch (Exception ex) {
            Assert.fail("Got unexpected exception when executing sizeOnServer", ex);
        }
    }

    private static void verifyIsEmptyOnServer(boolean isEmpty, int expectedResult) {
        Region region = SecurityTestUtils.getRegion(0, expectedResult);
        try {
            boolean isEmptyOnServer = region.isEmptyOnServer();
            if (expectedResult != 0) {
                Assert.fail((String)"Expected a NotAuthorizedException while executing isEmptyOnServer");
            }
            Assert.assertEquals((Object)isEmpty, (Object)isEmptyOnServer);
        }
        catch (NoSuchMethodError isEmptyOnServer) {
        }
        catch (Exception ex) {
            Assert.fail("Got unexpected exception when executing isEmptyOnServer", ex);
        }
    }

    private static void doPutsP(int num, int expectedResult, boolean newVals) {
        SecurityTestUtils.doPutsP(num, 0, expectedResult, newVals);
    }

    private static void doPutsP(int num, int multiUserIndex, int expectedResult, boolean newVals) {
        Assert.assertTrue((num <= KEYS.length ? 1 : 0) != 0);
        Region region = SecurityTestUtils.getRegion(multiUserIndex, expectedResult);
        for (int index = 0; index < num; ++index) {
            try {
                if (newVals) {
                    region.put((Object)KEYS[index], (Object)NVALUES[index]);
                } else {
                    region.put((Object)KEYS[index], (Object)VALUES[index]);
                }
                if (expectedResult == 0) continue;
                Assert.fail((String)"Expected a NotAuthorizedException while doing puts");
                continue;
            }
            catch (NoAvailableServersException ex) {
                if (expectedResult == 6) {
                    LogWriterUtils.getLogWriter().info("Got expected NoAvailableServers when doing puts: " + ex.getCause());
                    continue;
                }
                Assert.fail("Got unexpected exception when doing puts", ex);
                continue;
            }
            catch (ServerConnectivityException ex) {
                if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                    LogWriterUtils.getLogWriter().info("Got expected NotAuthorizedException when doing puts: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 1 && ex.getCause() instanceof AuthenticationRequiredException) {
                    LogWriterUtils.getLogWriter().info("Got expected AuthenticationRequiredException when doing puts: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 2 && ex.getCause() instanceof AuthenticationFailedException) {
                    LogWriterUtils.getLogWriter().info("Got expected AuthenticationFailedException when doing puts: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 5) {
                    LogWriterUtils.getLogWriter().info("Got expected exception when doing puts: " + (Object)((Object)ex));
                    continue;
                }
                Assert.fail("Got unexpected exception when doing puts", ex);
                continue;
            }
            catch (Exception ex) {
                if (expectedResult == 5) {
                    LogWriterUtils.getLogWriter().info("Got expected exception when doing puts: " + ex);
                    continue;
                }
                Assert.fail("Got unexpected exception when doing puts", ex);
            }
        }
    }

    private static Region getRegion(int multiUserIndex, int expectedResult) {
        Region region = null;
        try {
            if (multiUserAuthMode) {
                regionRef = region = proxyCaches[multiUserIndex].getRegion(REGION_NAME);
            } else {
                region = SecurityTestUtils.getCache().getRegion(REGION_NAME);
            }
            Assert.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception during getRegion: " + ex);
            }
            Assert.fail("Got unexpected exception during getRegion", ex);
        }
        return region;
    }

    private static Map<Field, Object> getSSLFields(Object obj, Class[] classes) {
        HashMap<Field, Object> resultFields = new HashMap<Field, Object>();
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            Field field = fields[index];
            try {
                field.setAccessible(true);
                Object fieldObj = field.get(obj);
                boolean isInstance = false;
                for (int classIndex = 0; classIndex < classes.length && !(isInstance = classes[classIndex].isInstance(fieldObj)); ++classIndex) {
                }
                if (!isInstance) continue;
                resultFields.put(field, fieldObj);
                continue;
            }
            catch (IllegalAccessException ex) {
                LogWriterUtils.getLogWriter().warning("Exception while getting SSL fields.", (Throwable)ex);
            }
        }
        return resultFields;
    }

    private static void makeNullSSLFields(Object obj, Map<Field, Object> fieldMap) {
        for (Map.Entry<Field, Object> entry : fieldMap.entrySet()) {
            Field field = entry.getKey();
            Object fieldObj = entry.getValue();
            try {
                field.setAccessible(true);
                SecurityTestUtils.makeNullStaticField(fieldObj.getClass());
                field.set(obj, null);
                Assert.assertNull((Object)field.get(obj));
            }
            catch (IllegalAccessException ex) {
                LogWriterUtils.getLogWriter().warning("Exception while clearing SSL fields.", (Throwable)ex);
            }
        }
    }

    private static void makeNullStaticField(Class sslClass) {
        Field[] fields = sslClass.getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            Field field = fields[index];
            try {
                if (!Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                if (field.getClass().equals(Boolean.TYPE)) {
                    field.setBoolean(null, false);
                    Assert.assertFalse((boolean)field.getBoolean(null));
                    continue;
                }
                if (!sslClass.isInstance(field.get(null))) continue;
                field.set(null, null);
                Assert.assertNull((Object)field.get(null));
                continue;
            }
            catch (IllegalAccessException ex) {
                LogWriterUtils.getLogWriter().warning("Exception while clearing static SSL field.", (Throwable)ex);
                continue;
            }
            catch (ClassCastException ex) {
                LogWriterUtils.getLogWriter().warning("Exception while clearing static SSL field.", (Throwable)ex);
            }
        }
    }

    private static void doQueryExecuteP(int multiUserIndex, int expectedResult, int expectedValue) {
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(REGION_NAME) : SecurityTestUtils.getCache().getRegion(REGION_NAME);
            Assert.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when executing query: " + ex);
            }
            Assert.fail("Got unexpected exception when executing query", ex);
        }
        try {
            String queryString = "SELECT DISTINCT * FROM " + region.getFullPath();
            Query query = null;
            if (multiUserAuthMode) {
                query = proxyCaches[multiUserIndex].getQueryService().newQuery(queryString);
            } else {
                region.getCache().getQueryService().newQuery(queryString);
            }
            SelectResults result = (SelectResults)query.execute();
            if (expectedResult != 0) {
                Assert.fail((String)"Expected a NotAuthorizedException while executing function");
            }
            Assert.assertEquals((long)expectedValue, (long)result.asList().size());
        }
        catch (NoAvailableServersException ex) {
            if (expectedResult == 6) {
                LogWriterUtils.getLogWriter().info("Got expected NoAvailableServers when executing query: " + ex.getCause());
            } else {
                Assert.fail("Got unexpected exception when executing query", ex);
            }
        }
        catch (ServerConnectivityException ex) {
            if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                LogWriterUtils.getLogWriter().info("Got expected NotAuthorizedException when executing query: " + ex.getCause());
            } else if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when executing query: " + (Object)((Object)ex));
            } else {
                Assert.fail("Got unexpected exception when executing query", ex);
            }
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when executing query: " + ex);
            }
            Assert.fail("Got unexpected exception when executing query", ex);
        }
    }

    private static void doFunctionExecuteP(int multiUserIndex, Function function, int expectedResult, String method) {
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(REGION_NAME) : SecurityTestUtils.getCache().getRegion(REGION_NAME);
            Assert.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when executing function: " + ex);
            }
            Assert.fail("Got unexpected exception when executing function", ex);
        }
        try {
            FunctionService.registerFunction((Function)function);
            Execution execution = null;
            execution = "region".equals(method) ? FunctionService.onRegion((Region)region) : ("server".equals(method) ? (multiUserAuthMode ? FunctionService.onServer((RegionService)proxyCaches[multiUserIndex]) : FunctionService.onServer((Pool)pool)) : (multiUserAuthMode ? FunctionService.onServers((RegionService)proxyCaches[multiUserIndex]) : FunctionService.onServers((Pool)pool)));
            execution.execute(function.getId());
            if (expectedResult != 0) {
                Assert.fail((String)"Expected a NotAuthorizedException while executing function");
            }
        }
        catch (NoAvailableServersException ex) {
            if (expectedResult == 6) {
                LogWriterUtils.getLogWriter().info("Got expected NoAvailableServers when executing function: " + ex.getCause());
            } else {
                Assert.fail("Got unexpected exception when executing function", ex);
            }
        }
        catch (ServerConnectivityException ex) {
            if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                LogWriterUtils.getLogWriter().info("Got expected NotAuthorizedException when executing function: " + ex.getCause());
            } else if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when executing function: " + (Object)((Object)ex));
            } else {
                Assert.fail("Got unexpected exception when executing function", ex);
            }
        }
        catch (FunctionException ex) {
            if (expectedResult == 4 && (ex.getCause() instanceof NotAuthorizedException || ex.getCause() instanceof ServerOperationException && ex.getCause().getCause() instanceof NotAuthorizedException)) {
                LogWriterUtils.getLogWriter().info("Got expected NotAuthorizedException when executing function: " + ex.getCause());
            } else if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when executing function: " + (Object)((Object)ex));
            } else {
                Assert.fail("Got unexpected exception when executing function", ex);
            }
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when executing function: " + ex);
            }
            Assert.fail("Got unexpected exception when executing function", ex);
        }
    }

    private static void doQueriesP(int multiUserIndex, int expectedResult, int expectedValue) {
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(REGION_NAME) : SecurityTestUtils.getCache().getRegion(REGION_NAME);
            Assert.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when doing queries: " + ex);
            }
            Assert.fail("Got unexpected exception when doing queries", ex);
        }
        String queryStr = "SELECT DISTINCT * FROM " + region.getFullPath();
        try {
            SelectResults queryResults = region.query(queryStr);
            Set resultSet = queryResults.asSet();
            Assert.assertEquals((long)expectedValue, (long)resultSet.size());
            if (expectedResult != 0) {
                Assert.fail((String)"Expected a NotAuthorizedException while doing queries");
            }
        }
        catch (NoAvailableServersException ex) {
            if (expectedResult == 6) {
                LogWriterUtils.getLogWriter().info("Got expected NoAvailableServers when doing queries: " + ex.getCause());
            } else {
                Assert.fail("Got unexpected exception when doing queries", ex);
            }
        }
        catch (ServerConnectivityException ex) {
            if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                LogWriterUtils.getLogWriter().info("Got expected NotAuthorizedException when doing queries: " + ex.getCause());
            } else if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when doing queries: " + (Object)((Object)ex));
            } else {
                Assert.fail("Got unexpected exception when doing queries", ex);
            }
        }
        catch (QueryInvocationTargetException qite) {
            if (expectedResult == 4 && qite.getCause() instanceof NotAuthorizedException) {
                LogWriterUtils.getLogWriter().info("Got expected NotAuthorizedException when doing queries: " + qite.getCause());
            } else if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when doing queries: " + (Object)((Object)qite));
            } else {
                Assert.fail("Got unexpected exception when doing queries", qite);
            }
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when doing queries: " + ex);
            }
            Assert.fail("Got unexpected exception when doing queries", ex);
        }
    }

    private static void doContainsKeysP(int num, int multiUserIndex, int expectedResult, boolean expectedValue) {
        Assert.assertTrue((num <= KEYS.length ? 1 : 0) != 0);
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(REGION_NAME) : SecurityTestUtils.getCache().getRegion(REGION_NAME);
            Assert.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when doing containsKey: " + ex);
            }
            Assert.fail("Got unexpected exception when doing containsKey", ex);
        }
        for (int index = 0; index < num; ++index) {
            boolean result = false;
            try {
                result = region.containsKeyOnServer((Object)KEYS[index]);
                if (expectedResult != 0) {
                    Assert.fail((String)"Expected a NotAuthorizedException while doing containsKey");
                }
            }
            catch (NoAvailableServersException ex) {
                if (expectedResult == 6) {
                    LogWriterUtils.getLogWriter().info("Got expected NoAvailableServers when doing containsKey: " + ex.getCause());
                    continue;
                }
                Assert.fail("Got unexpected exception when doing containsKey", ex);
            }
            catch (ServerConnectivityException ex) {
                if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                    LogWriterUtils.getLogWriter().info("Got expected NotAuthorizedException when doing containsKey: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 5) {
                    LogWriterUtils.getLogWriter().info("Got expected exception when doing containsKey: " + (Object)((Object)ex));
                } else {
                    Assert.fail("Got unexpected exception when doing containsKey", ex);
                }
            }
            catch (Exception ex) {
                if (expectedResult == 5) {
                    LogWriterUtils.getLogWriter().info("Got expected exception when doing containsKey: " + ex);
                }
                Assert.fail("Got unexpected exception when doing containsKey", ex);
            }
            Assert.assertEquals((Object)expectedValue, (Object)result);
        }
    }

    private static void doInvalidatesP(int num, int multiUserIndex, int expectedResult) {
        Assert.assertTrue((num <= KEYS.length ? 1 : 0) != 0);
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(REGION_NAME) : SecurityTestUtils.getCache().getRegion(REGION_NAME);
            Assert.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when doing invalidates: " + ex);
            }
            Assert.fail("Got unexpected exception when doing invalidates", ex);
        }
        for (int index = 0; index < num; ++index) {
            try {
                region.invalidate((Object)KEYS[index]);
                if (expectedResult == 0) continue;
                Assert.fail((String)"Expected a NotAuthorizedException while doing invalidates");
                continue;
            }
            catch (NoAvailableServersException ex) {
                if (expectedResult == 6) {
                    LogWriterUtils.getLogWriter().info("Got expected NoAvailableServers when doing invalidates: " + ex.getCause());
                    continue;
                }
                Assert.fail("Got unexpected exception when doing invalidates", ex);
                continue;
            }
            catch (ServerConnectivityException ex) {
                if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                    LogWriterUtils.getLogWriter().info("Got expected NotAuthorizedException when doing invalidates: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 5) {
                    LogWriterUtils.getLogWriter().info("Got expected exception when doing invalidates: " + (Object)((Object)ex));
                    continue;
                }
                Assert.fail("Got unexpected exception when doing invalidates", ex);
                continue;
            }
            catch (Exception ex) {
                if (expectedResult == 5) {
                    LogWriterUtils.getLogWriter().info("Got expected exception when doing invalidates: " + ex);
                    continue;
                }
                Assert.fail("Got unexpected exception when doing invalidates", ex);
            }
        }
    }

    private static void doDestroysP(int num, int multiUserIndex, int expectedResult) {
        Assert.assertTrue((num <= KEYS.length ? 1 : 0) != 0);
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(REGION_NAME) : SecurityTestUtils.getCache().getRegion(REGION_NAME);
            Assert.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when doing destroys: " + ex);
            }
            Assert.fail("Got unexpected exception when doing destroys", ex);
        }
        for (int index = 0; index < num; ++index) {
            try {
                region.destroy((Object)KEYS[index]);
                if (expectedResult == 0) continue;
                Assert.fail((String)"Expected a NotAuthorizedException while doing destroys");
                continue;
            }
            catch (NoAvailableServersException ex) {
                if (expectedResult == 6) {
                    LogWriterUtils.getLogWriter().info("Got expected NoAvailableServers when doing destroys: " + ex.getCause());
                    continue;
                }
                Assert.fail("Got unexpected exception when doing destroys", ex);
                continue;
            }
            catch (ServerConnectivityException ex) {
                if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                    LogWriterUtils.getLogWriter().info("Got expected NotAuthorizedException when doing destroys: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 5) {
                    LogWriterUtils.getLogWriter().info("Got expected exception when doing destroys: " + (Object)((Object)ex));
                    continue;
                }
                Assert.fail("Got unexpected exception when doing destroys", ex);
                continue;
            }
            catch (Exception ex) {
                if (expectedResult == 5) {
                    LogWriterUtils.getLogWriter().info("Got expected exception when doing destroys: " + ex);
                    continue;
                }
                Assert.fail("Got unexpected exception when doing destroys", ex);
            }
        }
    }

    private static void doRegionDestroysP(int multiUserIndex, int expectedResult) {
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(REGION_NAME) : SecurityTestUtils.getCache().getRegion(REGION_NAME);
            Assert.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when doing region destroy: " + ex);
            }
            Assert.fail("Got unexpected exception when doing region destroy", ex);
        }
        try {
            region.destroyRegion();
            if (expectedResult != 0) {
                Assert.fail((String)"Expected a NotAuthorizedException while doing region destroy");
            }
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(REGION_NAME) : SecurityTestUtils.getCache().getRegion(REGION_NAME);
            Assert.assertNull((Object)region);
        }
        catch (NoAvailableServersException ex) {
            if (expectedResult == 6) {
                LogWriterUtils.getLogWriter().info("Got expected NoAvailableServers when doing region destroy: " + ex.getCause());
            } else {
                Assert.fail("Got unexpected exception when doing region destroy", ex);
            }
        }
        catch (ServerConnectivityException ex) {
            if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                LogWriterUtils.getLogWriter().info("Got expected NotAuthorizedException when doing region destroy: " + ex.getCause());
            } else if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when doing region destroy: " + (Object)((Object)ex));
            } else {
                Assert.fail("Got unexpected exception when doing region destroy", ex);
            }
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when doing region destroy: " + ex);
            }
            Assert.fail("Got unexpected exception when doing region destroy", ex);
        }
    }

    private static void doLocalGetsP(int num, boolean checkNVals) {
        int index;
        Assert.assertTrue((num <= KEYS.length ? 1 : 0) != 0);
        String[] vals = VALUES;
        if (checkNVals) {
            vals = NVALUES;
        }
        Region region = SecurityTestUtils.getCache().getRegion(REGION_NAME);
        Assert.assertNotNull((Object)region);
        for (index = 0; index < num; ++index) {
            String key = KEYS[index];
            String expectedVal = vals[index];
            Awaitility.waitAtMost((long)5L, (TimeUnit)TimeUnit.MINUTES).pollInterval(200L, TimeUnit.MILLISECONDS).until(() -> expectedVal.equals(SecurityTestUtils.getLocalValue(region, key)));
        }
        for (index = 0; index < num; ++index) {
            Region.Entry entry = region.getEntry((Object)KEYS[index]);
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((Object)vals[index], (Object)entry.getValue());
        }
    }

    private static void doGetAllP(int multiUserIndex, int expectedResult, boolean useTX) {
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(REGION_NAME) : SecurityTestUtils.getCache().getRegion(REGION_NAME);
            Assert.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when doing getAll: " + ex);
            }
            Assert.fail("Got unexpected exception when doing getAll", ex);
        }
        try {
            ArrayList<String> keys = new ArrayList<String>();
            keys.add("key1");
            keys.add("key2");
            if (useTX) {
                SecurityTestUtils.getCache().getCacheTransactionManager().begin();
            }
            Map entries = region.getAll(keys);
            region.getEntry((Object)"key1");
            if (useTX) {
                SecurityTestUtils.getCache().getCacheTransactionManager().commit();
            }
            Assert.assertNotNull((Object)entries);
            if (expectedResult == 4) {
                Assert.assertEquals((long)0L, (long)entries.size());
            } else if (expectedResult == 0) {
                Assert.assertEquals((long)2L, (long)entries.size());
                Assert.assertEquals((Object)"value1", entries.get("key1"));
                Assert.assertEquals((Object)"value2", entries.get("key2"));
            }
        }
        catch (NoAvailableServersException ex) {
            if (expectedResult == 6) {
                LogWriterUtils.getLogWriter().info("Got expected NoAvailableServers when doing getAll: " + ex.getCause());
            } else {
                Assert.fail("Got unexpected exception when doing getAll", ex);
            }
        }
        catch (ServerConnectivityException ex) {
            if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                LogWriterUtils.getLogWriter().info("Got expected NotAuthorizedException when doing getAll: " + ex.getCause());
            } else if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when doing getAll: " + (Object)((Object)ex));
            } else {
                Assert.fail("Got unexpected exception when doing getAll", ex);
            }
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when doing getAll: " + ex);
            }
            Assert.fail("Got unexpected exception when doing getAll", ex);
        }
    }

    private static void doGetsP(int num, int expectedResult, boolean newVals) {
        SecurityTestUtils.doGetsP(num, 0, expectedResult, newVals);
    }

    private static void doGetsP(int num, int multiUserIndex, int expectedResult, boolean newVals) {
        Assert.assertTrue((num <= KEYS.length ? 1 : 0) != 0);
        Region region = null;
        try {
            region = multiUserAuthMode ? proxyCaches[multiUserIndex].getRegion(REGION_NAME) : SecurityTestUtils.getCache().getRegion(REGION_NAME);
            Assert.assertNotNull((Object)region);
        }
        catch (Exception ex) {
            if (expectedResult == 5) {
                LogWriterUtils.getLogWriter().info("Got expected exception when doing gets: " + ex);
            }
            Assert.fail("Got unexpected exception when doing gets", ex);
        }
        for (int index = 0; index < num; ++index) {
            Object value = null;
            try {
                try {
                    region.localInvalidate((Object)KEYS[index]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                value = region.get((Object)KEYS[index]);
                if (expectedResult != 0) {
                    Assert.fail((String)"Expected a NotAuthorizedException while doing gets");
                }
            }
            catch (NoAvailableServersException ex) {
                if (expectedResult == 6) {
                    LogWriterUtils.getLogWriter().info("Got expected NoAvailableServers when doing gets: " + ex.getCause());
                    continue;
                }
                Assert.fail("Got unexpected exception when doing gets", ex);
            }
            catch (ServerConnectivityException ex) {
                if (expectedResult == 4 && ex.getCause() instanceof NotAuthorizedException) {
                    LogWriterUtils.getLogWriter().info("Got expected NotAuthorizedException when doing gets: " + ex.getCause());
                    continue;
                }
                if (expectedResult == 5) {
                    LogWriterUtils.getLogWriter().info("Got expected exception when doing gets: " + (Object)((Object)ex));
                } else {
                    Assert.fail("Got unexpected exception when doing gets", ex);
                }
            }
            catch (Exception ex) {
                if (expectedResult == 5) {
                    LogWriterUtils.getLogWriter().info("Got expected exception when doing gets: " + ex);
                }
                Assert.fail("Got unexpected exception when doing gets", ex);
            }
            Assert.assertNotNull((Object)value);
            if (newVals) {
                Assert.assertEquals((Object)NVALUES[index], (Object)value);
                continue;
            }
            Assert.assertEquals((Object)VALUES[index], (Object)value);
        }
    }

    public DistributedSystem createSystem(Properties sysProps, Properties javaProps) {
        SecurityTestUtils.closeCache();
        SecurityTestUtils.clearStaticSSLContext();
        SecurityTestUtils.setJavaProps(javaProps);
        InternalDistributedSystem dsys = this.distributedTestCase.getSystem(sysProps);
        Assert.assertNotNull((Object)dsys);
        SecurityTestUtils.addIgnoredExceptions(ignoredExceptions);
        return dsys;
    }

    private void openCache() {
        Assert.assertNotNull((Object)this.distributedTestCase.basicGetSystem());
        Assert.assertTrue((boolean)this.distributedTestCase.basicGetSystem().isConnected());
        cache = CacheFactory.create((DistributedSystem)this.distributedTestCase.basicGetSystem());
        Assert.assertNotNull((Object)cache);
    }

    public static class Employee
    implements PdxSerializable {
        private Long Id;
        private String fname;
        private String lname;

        public Employee() {
        }

        public Employee(Long id, String fn, String ln) {
            this.Id = id;
            this.fname = fn;
            this.lname = ln;
        }

        public void fromData(PdxReader in) {
            throw new UnsupportedOperationException();
        }

        public void toData(PdxWriter out) {
            out.writeLong("Id", this.Id.longValue());
            out.writeString("fname", this.fname);
            out.writeString("lname", this.lname);
        }
    }
}

