/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management;

import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.LocatorMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.internal.SystemManagementService;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;

public class MXBeanAwaitility {
    public static LocatorMXBean awaitLocalLocatorMXBean() {
        SystemManagementService service = MXBeanAwaitility.getSystemManagementService();
        MXBeanAwaitility.await().atMost(2L, TimeUnit.MINUTES).untilAsserted(() -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)service.getLocalLocatorMXBean()).isNotNull();
        });
        return service.getLocalLocatorMXBean();
    }

    public static LocatorMXBean awaitLocatorMXBeanProxy(DistributedMember member) {
        SystemManagementService service = MXBeanAwaitility.getSystemManagementService();
        ObjectName objectName = service.getLocatorMBeanName(member);
        String alias = "Awaiting LocatorMXBean proxy for " + member;
        MXBeanAwaitility.await(alias).untilAsserted(() -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)service.getMBeanProxy(objectName, LocatorMXBean.class)).isNotNull();
        });
        return (LocatorMXBean)service.getMBeanProxy(objectName, LocatorMXBean.class);
    }

    public static GatewaySenderMXBean awaitGatewaySenderMXBeanProxy(DistributedMember member, String senderId) {
        SystemManagementService service = MXBeanAwaitility.getSystemManagementService();
        ObjectName objectName = service.getGatewaySenderMBeanName(member, senderId);
        String alias = "Awaiting GatewaySenderMXBean proxy for " + member;
        MXBeanAwaitility.await(alias).untilAsserted(() -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)service.getMBeanProxy(objectName, GatewaySenderMXBean.class)).isNotNull();
        });
        return (GatewaySenderMXBean)service.getMBeanProxy(objectName, GatewaySenderMXBean.class);
    }

    public static GatewayReceiverMXBean awaitGatewayReceiverMXBeanProxy(DistributedMember member) {
        SystemManagementService service = MXBeanAwaitility.getSystemManagementService();
        ObjectName objectName = service.getGatewayReceiverMBeanName(member);
        String alias = "Awaiting GatewayReceiverMXBean proxy for " + member;
        MXBeanAwaitility.await(alias).untilAsserted(() -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)service.getMBeanProxy(objectName, GatewayReceiverMXBean.class)).isNotNull();
        });
        return (GatewayReceiverMXBean)service.getMBeanProxy(objectName, GatewayReceiverMXBean.class);
    }

    public static SystemManagementService getSystemManagementService() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        return (SystemManagementService)ManagementService.getExistingManagementService((Cache)cache);
    }

    public static ConditionFactory await() {
        return Awaitility.await().atMost(2L, TimeUnit.MINUTES);
    }

    public static ConditionFactory await(String alias) {
        return Awaitility.await((String)alias).atMost(2L, TimeUnit.MINUTES);
    }

    public static MemberMXBean awaitMemberMXBeanProxy(DistributedMember member) {
        return MXBeanAwaitility.awaitMemberMXBeanProxy(member, MXBeanAwaitility.getSystemManagementService());
    }

    public static MemberMXBean awaitMemberMXBeanProxy(DistributedMember member, SystemManagementService managementService) {
        ObjectName objectName = managementService.getMemberMBeanName(member);
        String alias = "Awaiting MemberMXBean proxy for " + member;
        MXBeanAwaitility.await(alias).untilAsserted(() -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)managementService.getMBeanProxy(objectName, MemberMXBean.class)).isNotNull();
        });
        return (MemberMXBean)managementService.getMBeanProxy(objectName, MemberMXBean.class);
    }
}

