/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache30;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache30.TestCacheListener;
import org.apache.geode.internal.cache.xmlcache.Declarable2;
import org.apache.geode.test.dunit.Wait;
import org.apache.geode.test.dunit.WaitCriterion;

public class CertifiableTestCacheListener
extends TestCacheListener
implements Declarable2 {
    public final Set destroys = Collections.synchronizedSet(new HashSet());
    public final Set creates = Collections.synchronizedSet(new HashSet());
    public final Set invalidates = Collections.synchronizedSet(new HashSet());
    public final Set updates = Collections.synchronizedSet(new HashSet());
    final LogWriter logger;
    private static final String WAIT_PROPERTY = "CertifiableTestCacheListener.maxWaitTime";
    private static final int WAIT_DEFAULT = 30000;
    public static final long MAX_TIME = Integer.getInteger("CertifiableTestCacheListener.maxWaitTime", 30000).intValue();

    public CertifiableTestCacheListener(LogWriter l) {
        this.logger = l;
    }

    public void clearState() {
        this.destroys.clear();
        this.creates.clear();
        this.invalidates.clear();
        this.updates.clear();
    }

    public List getEventHistory() {
        this.destroys.clear();
        this.creates.clear();
        this.invalidates.clear();
        this.updates.clear();
        return super.getEventHistory();
    }

    public void afterCreate2(EntryEvent event) {
        this.creates.add(event.getKey());
    }

    public void afterDestroy2(EntryEvent event) {
        this.destroys.add(event.getKey());
    }

    public void afterInvalidate2(EntryEvent event) {
        Object key = event.getKey();
        this.invalidates.add(key);
    }

    public void afterUpdate2(EntryEvent event) {
        this.updates.add(event.getKey());
    }

    public boolean waitForCreated(final Object key) {
        WaitCriterion ev = new WaitCriterion(){

            @Override
            public boolean done() {
                return CertifiableTestCacheListener.this.creates.contains(key);
            }

            @Override
            public String description() {
                return "Waiting for key creation: " + key;
            }
        };
        Wait.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public boolean waitForDestroyed(final Object key) {
        WaitCriterion ev = new WaitCriterion(){

            @Override
            public boolean done() {
                return CertifiableTestCacheListener.this.destroys.contains(key);
            }

            @Override
            public String description() {
                return "Waiting for key destroy: " + key;
            }
        };
        Wait.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public boolean waitForInvalidated(final Object key) {
        WaitCriterion ev = new WaitCriterion(){

            @Override
            public boolean done() {
                return CertifiableTestCacheListener.this.invalidates.contains(key);
            }

            @Override
            public String description() {
                return "Waiting for key invalidate: " + key;
            }
        };
        Wait.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public boolean waitForUpdated(final Object key) {
        WaitCriterion ev = new WaitCriterion(){

            @Override
            public boolean done() {
                return CertifiableTestCacheListener.this.updates.contains(key);
            }

            @Override
            public String description() {
                return "Waiting for key update: " + key;
            }
        };
        Wait.waitForCriterion(ev, MAX_TIME, 200L, true);
        return true;
    }

    public Properties getConfig() {
        return null;
    }

    public void init(Properties props) {
    }
}

