/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Properties;
import java.util.function.UnaryOperator;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.ServerLauncher;
import org.apache.geode.test.junit.rules.serializable.SerializableExternalResource;
import org.apache.geode.test.junit.rules.serializable.SerializableTemporaryFolder;
import org.junit.rules.TemporaryFolder;

public class ServerLauncherStartupRule
extends SerializableExternalResource {
    private ServerLauncher launcher;
    private final TemporaryFolder temp = new SerializableTemporaryFolder();
    private final Properties properties = new Properties();
    private boolean autoStart;
    private UnaryOperator<ServerLauncher.Builder> builderOperator;

    public ServerLauncherStartupRule withAutoStart() {
        this.autoStart = true;
        return this;
    }

    public ServerLauncherStartupRule withProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public ServerLauncherStartupRule withProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public ServerLauncherStartupRule withBuilder(UnaryOperator<ServerLauncher.Builder> builderOperator) {
        this.builderOperator = builderOperator;
        return this;
    }

    public void before() {
        ServerLauncher.Builder builder = new ServerLauncher.Builder().setServerPort(Integer.valueOf(0)).set(this.properties).setMemberName("server-0").set("log-level", "config");
        if (this.builderOperator != null) {
            builder = (ServerLauncher.Builder)this.builderOperator.apply(builder);
        }
        try {
            this.temp.create();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        builder.setWorkingDirectory(this.temp.getRoot().getAbsolutePath());
        this.launcher = builder.build();
        if (this.autoStart) {
            this.start();
        }
    }

    public void start() {
        this.launcher.start();
    }

    public void after() {
        if (this.launcher != null) {
            this.launcher.stop();
        }
        this.temp.delete();
    }

    public Cache getCache() {
        return this.launcher.getCache();
    }
}

