/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.internal;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.assertj.core.api.Assertions;

class StackTraceInfo
implements Serializable {
    private final String message;
    private final StackTraceElement[] stackTraceElements;

    static StackTraceInfo create(int vmId, long threadId) {
        long[] threadIds = new long[]{threadId};
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Object[] threadInfos = threadMXBean.getThreadInfo(threadIds, true, true);
        Assertions.assertThat((Object[])threadInfos).hasSize(1);
        String message = "Stack trace for vm-" + vmId + " thread-" + threadId;
        return new StackTraceInfo(message, ((ThreadInfo)threadInfos[0]).getStackTrace());
    }

    StackTraceInfo(String message, StackTraceElement[] stackTraceElements) {
        this.message = message;
        this.stackTraceElements = stackTraceElements;
    }

    String getMessage() {
        return this.message;
    }

    StackTraceElement[] getStackTraceElements() {
        return this.stackTraceElements;
    }
}

