/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.cache.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache30.CacheSerializableRunnable;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DistributionMessageObserver;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.cache.xmlcache.CacheXmlGenerator;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.IgnoredException;
import org.apache.geode.test.dunit.Invoke;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.cache.internal.CacheTestFixture;
import org.apache.geode.test.dunit.internal.JUnit4DistributedTestCase;
import org.apache.logging.log4j.Logger;

@Deprecated
public abstract class JUnit4CacheTestCase
extends JUnit4DistributedTestCase
implements CacheTestFixture {
    protected static final Logger logger = LogService.getLogger();
    protected static InternalCache cache;
    private final CacheTestFixture cacheTestFixture;
    private final String RootRegionName = "root";

    public JUnit4CacheTestCase() {
        this(null);
    }

    JUnit4CacheTestCase(CacheTestFixture cacheTestFixture) {
        super(cacheTestFixture);
        this.cacheTestFixture = cacheTestFixture == null ? this : cacheTestFixture;
    }

    private void createCache() {
        this.createCache(false);
    }

    private void createCache(boolean client) {
        this.createCache(client, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCache(boolean client, CacheFactory factory) {
        Class<JUnit4CacheTestCase> clazz = JUnit4CacheTestCase.class;
        synchronized (JUnit4CacheTestCase.class) {
            try {
                InternalCache newCache;
                System.setProperty("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE", "true");
                if (client) {
                    System.setProperty("gemfire.locators", "");
                    System.setProperty("gemfire.mcast-port", "0");
                    newCache = (InternalCache)new ClientCacheFactory(this.getSystem().getProperties()).create();
                } else if (factory == null) {
                    newCache = (InternalCache)CacheFactory.create((DistributedSystem)this.getSystem());
                } else {
                    Properties config = this.getSystem().getProperties();
                    for (Map.Entry<Object, Object> entry : config.entrySet()) {
                        factory.set((String)entry.getKey(), (String)entry.getValue());
                    }
                    newCache = (InternalCache)factory.create();
                }
                cache = newCache;
            }
            finally {
                System.clearProperty("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE");
                System.clearProperty("gemfire.locators");
                System.clearProperty("gemfire.mcast-port");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void beginCacheXml() {
        JUnit4CacheTestCase.closeCache();
        cache = new TestCacheCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finishCacheXml(String name) {
        Class<JUnit4CacheTestCase> clazz = JUnit4CacheTestCase.class;
        synchronized (JUnit4CacheTestCase.class) {
            try {
                File file = new File(name + "-cache.xml");
                PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(file), true);
                CacheXmlGenerator.generate((Cache)cache, (PrintWriter)printWriter);
                printWriter.close();
                cache = null;
                GemFireCacheImpl.testCacheXml = file;
                this.createCache();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                GemFireCacheImpl.testCacheXml = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finishCacheXml(File root, String name, boolean useSchema, String xmlVersion) throws IOException {
        Class<JUnit4CacheTestCase> clazz = JUnit4CacheTestCase.class;
        synchronized (JUnit4CacheTestCase.class) {
            File dir = new File(root, "XML_" + xmlVersion);
            dir.mkdirs();
            File file = new File(dir, name + ".xml");
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(file), true);
            CacheXmlGenerator.generate((Cache)cache, (PrintWriter)printWriter, (boolean)useSchema, (String)xmlVersion);
            printWriter.close();
            cache = null;
            GemFireCacheImpl.testCacheXml = file;
            try {
                this.createCache();
            }
            finally {
                GemFireCacheImpl.testCacheXml = null;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public final InternalCache getCache() {
        return this.getCache(false);
    }

    public final InternalCache getCache(CacheFactory factory) {
        return this.getCache(false, factory);
    }

    public final InternalCache getCache(Properties properties) {
        this.getSystem(properties);
        return this.getCache();
    }

    public final InternalCache getCache(boolean client) {
        return this.getCache(client, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InternalCache getCache(boolean client, CacheFactory factory) {
        Class<JUnit4CacheTestCase> clazz = JUnit4CacheTestCase.class;
        synchronized (JUnit4CacheTestCase.class) {
            GemFireCacheImpl gemFireCache = GemFireCacheImpl.getInstance();
            if (gemFireCache != null && !gemFireCache.isClosed() && gemFireCache.getCancelCriterion().isCancelInProgress()) {
                GeodeAwaitility.await((String)"waiting for cache to close").until(() -> ((InternalCache)gemFireCache).isClosed());
            }
            if (cache == null || cache.isClosed()) {
                cache = null;
                this.createCache(client, factory);
            }
            if (client && cache != null) {
                IgnoredException.addIgnoredException("java.net.ConnectException");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ClientCache getClientCache(ClientCacheFactory factory) {
        Class<JUnit4CacheTestCase> clazz = JUnit4CacheTestCase.class;
        synchronized (JUnit4CacheTestCase.class) {
            GemFireCacheImpl gemFireCache = GemFireCacheImpl.getInstance();
            if (gemFireCache != null && !gemFireCache.isClosed() && gemFireCache.getCancelCriterion().isCancelInProgress()) {
                GeodeAwaitility.await((String)"waiting for cache to close").until(() -> ((InternalCache)gemFireCache).isClosed());
            }
            if (cache == null || cache.isClosed()) {
                cache = null;
                JUnit4CacheTestCase.disconnectFromDS();
                cache = (InternalCache)factory.create();
            }
            if (cache != null) {
                IgnoredException.addIgnoredException("java.net.ConnectException");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (ClientCache)cache;
        }
    }

    public final ClientCache getClientCache() {
        return (ClientCache)cache;
    }

    @Deprecated
    public final GemFireCacheImpl getGemfireCache() {
        return (GemFireCacheImpl)this.getCache();
    }

    public static synchronized boolean hasCache() {
        return cache != null;
    }

    public static synchronized InternalCache basicGetCache() {
        return cache;
    }

    public static synchronized void closeCache() {
        block10: {
            if (cache == null) {
                cache = GemFireCacheImpl.getInstance();
            }
            try {
                if (cache == null) break block10;
                try {
                    TXManagerImpl transactionManager;
                    if (cache.isClosed()) break block10;
                    if (cache instanceof GemFireCacheImpl && (transactionManager = cache.getTxManager()) != null && transactionManager.exists()) {
                        try {
                            transactionManager.rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    cache.close();
                }
                finally {
                    cache = null;
                }
            }
            finally {
                PoolManager.close((boolean)false);
            }
        }
    }

    protected final void closeAllCache() {
        JUnit4CacheTestCase.closeCache();
        Invoke.invokeInEveryVM(JUnit4CacheTestCase::closeCache);
    }

    @Override
    public final void preTearDown() throws Exception {
        this.preTearDownCacheTestCase();
        this.tearDownCacheTestCase();
        this.postTearDownCacheTestCase();
    }

    private void tearDownCacheTestCase() {
        JUnit4CacheTestCase.remoteTearDown();
        Invoke.invokeInEveryVM(JUnit4CacheTestCase::remoteTearDown);
    }

    @Override
    public void preTearDownCacheTestCase() throws Exception {
        if (this.cacheTestFixture != this) {
            this.cacheTestFixture.preTearDownCacheTestCase();
        }
    }

    @Override
    public void postTearDownCacheTestCase() throws Exception {
        if (this.cacheTestFixture != this) {
            this.cacheTestFixture.postTearDownCacheTestCase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void remoteTearDown() {
        try {
            DistributionMessageObserver.setInstance(null);
            JUnit4CacheTestCase.destroyRegions((Cache)cache);
        }
        finally {
            try {
                JUnit4CacheTestCase.closeCache();
            }
            finally {
                try {
                    JUnit4CacheTestCase.cleanDiskDirs();
                }
                catch (Exception e) {
                    logger.error("Error cleaning disk dirs", (Throwable)e);
                }
            }
        }
    }

    private <K, V> AttributesFactory<K, V> getRootAttributesFactory(RegionAttributes<K, V> regionAttributes) {
        AttributesFactory attributesFactory = new AttributesFactory(regionAttributes);
        ExpirationAttributes expiration = ExpirationAttributes.DEFAULT;
        attributesFactory.setCacheLoader(null);
        attributesFactory.setCacheWriter(null);
        attributesFactory.setPoolName(null);
        attributesFactory.setRegionTimeToLive(expiration);
        attributesFactory.setEntryTimeToLive(expiration);
        attributesFactory.setRegionIdleTimeout(expiration);
        attributesFactory.setEntryIdleTimeout(expiration);
        return attributesFactory;
    }

    private <K, V> RegionFactory<K, V> getRootRegionFactory(RegionFactory<K, V> regionFactory) {
        MyRegionFactory<K, V> regionFactory1 = new MyRegionFactory<K, V>(regionFactory);
        ExpirationAttributes expiration = ExpirationAttributes.DEFAULT;
        regionFactory1.setCacheLoader(null);
        regionFactory1.setCacheWriter(null);
        regionFactory1.setPoolName(null);
        regionFactory1.setRegionTimeToLive(expiration);
        regionFactory1.setEntryTimeToLive(expiration);
        regionFactory1.setRegionIdleTimeout(expiration);
        regionFactory1.setEntryIdleTimeout(expiration);
        return regionFactory1;
    }

    public final <K, V> Region<K, V> createPartitionedRegion(String rootName, RegionAttributes<K, V> attributes) throws CacheException {
        Region<K, V> root = this.getRootRegion(rootName);
        if (root == null) {
            AttributesFactory<K, V> attributesFactory = this.getRootAttributesFactory(attributes);
            attributesFactory.setDataPolicy(DataPolicy.PARTITION);
            RegionAttributes rootAttrs = attributesFactory.create();
            root = this.createRootRegion(rootName, rootAttrs);
        }
        return root;
    }

    public final <K, V> Region<K, V> createPartitionedRegion(String rootName, RegionFactory<K, V> regionFactory) throws CacheException {
        Region root = this.getRootRegion(rootName);
        if (root == null) {
            RegionFactory<K, V> regionFactory1 = this.getRootRegionFactory(regionFactory);
            regionFactory1.setDataPolicy(DataPolicy.PARTITION);
            root = regionFactory1.create(rootName);
        }
        return root;
    }

    public final <K, V> Region<K, V> createRegion(String name, String rootName, RegionAttributes<K, V> attributes) throws CacheException {
        Region<K, V> root = this.getRootRegion(rootName);
        if (root == null) {
            AttributesFactory<K, V> attributesFactory = this.getRootAttributesFactory(attributes);
            attributesFactory.setPartitionAttributes(null);
            RegionAttributes rootAttrs = attributesFactory.create();
            root = this.createRootRegion(rootName, rootAttrs);
        }
        return root.createSubregion(name, attributes);
    }

    public final <K, V> Region<K, V> createRegion(String name, String rootName, RegionFactory<K, V> regionFactory) throws CacheException {
        Region root = this.getRootRegion(rootName);
        if (root == null) {
            RegionFactory<K, V> regionFactoryRoot = this.getRootRegionFactory(regionFactory);
            regionFactoryRoot.setPartitionAttributes(null);
            root = regionFactoryRoot.create(rootName);
        }
        return regionFactory.createSubregion(root, name);
    }

    public final <K, V> Region<K, V> createRegion(String name, RegionAttributes<K, V> attributes) throws CacheException {
        return this.createRegion(name, "root", attributes);
    }

    public final <K, V> Region<K, V> createRegion(String name, RegionFactory<K, V> regionFactory) throws CacheException {
        return this.createRegion(name, "root", regionFactory);
    }

    public final <K, V> Region<K, V> getRootRegion() {
        return this.getRootRegion("root");
    }

    public final <K, V> Region<K, V> getRootRegion(String rootName) {
        return this.getCache().getRegion(rootName);
    }

    protected final <K, V> Region<K, V> createRootRegion(RegionAttributes<K, V> attributes) throws RegionExistsException, TimeoutException {
        return this.createRootRegion("root", attributes);
    }

    public final <K, V> Region<K, V> createRootRegion(RegionFactory<K, V> regionFactory) throws RegionExistsException, TimeoutException {
        return regionFactory.create("root");
    }

    public final <K, V> Region<K, V> createRootRegion(String rootName, RegionAttributes<K, V> attributes) throws RegionExistsException, TimeoutException {
        return this.getCache().createRegion(rootName, attributes);
    }

    public final <K, V> Region<K, V> createRootRegion(String rootName, RegionFactory<K, V> regionFactory) throws RegionExistsException, TimeoutException {
        return regionFactory.create(rootName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <K, V> Region<K, V> createExpiryRootRegion(String rootName, RegionAttributes<K, V> attributes) throws RegionExistsException, TimeoutException {
        System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
        try {
            Region<K, V> region = this.createRootRegion(rootName, attributes);
            return region;
        }
        finally {
            System.clearProperty("gemfire.EXPIRY_UNITS_MS");
        }
    }

    @Deprecated
    public final CacheSerializableRunnable addExceptionTag1(final String exceptionStringToIgnore) {
        return new CacheSerializableRunnable("addExceptionTag"){

            @Override
            public void run2() {
                JUnit4CacheTestCase.this.getCache().getLogger().info("<ExpectedException action=add>" + exceptionStringToIgnore + "</ExpectedException>");
            }
        };
    }

    @Deprecated
    public final CacheSerializableRunnable removeExceptionTag1(final String exceptionStringToIgnore) {
        return new CacheSerializableRunnable("removeExceptionTag"){

            @Override
            public void run2() throws CacheException {
                JUnit4CacheTestCase.this.getCache().getLogger().info("<ExpectedException action=remove>" + exceptionStringToIgnore + "</ExpectedException>");
            }
        };
    }

    public static File getDiskDir() {
        int vmNum = VM.getCurrentVMNum();
        File dir = new File("diskDir", "disk" + vmNum).getAbsoluteFile();
        dir.mkdirs();
        return dir;
    }

    public static File[] getDiskDirs() {
        return new File[]{JUnit4CacheTestCase.getDiskDir()};
    }

    private static class TestCacheCreation
    extends CacheCreation {
        private boolean closed = false;

        private TestCacheCreation() {
        }

        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }

    protected static class MyRegionFactory<K, V>
    extends RegionFactory<K, V> {
        MyRegionFactory(RegionFactory<K, V> regionFactory) {
            super(regionFactory);
        }
    }
}

