/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.dunit.Blackboard;
import org.apache.geode.test.dunit.internal.InternalBlackboard;
import org.apache.geode.test.dunit.internal.InternalBlackboardImpl;

public class DUnitBlackboard
implements Blackboard {
    private final InternalBlackboard blackboard;

    public DUnitBlackboard() {
        this(InternalBlackboardImpl.getInstance());
    }

    public DUnitBlackboard(InternalBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    @Override
    public void initBlackboard() {
        try {
            this.blackboard.initBlackboard();
        }
        catch (RemoteException e) {
            throw new RuntimeException("remote call failed", e);
        }
    }

    @Override
    public void signalGate(String gateName) {
        try {
            this.blackboard.signalGate(gateName);
        }
        catch (RemoteException e) {
            throw new RuntimeException("remote call failed", e);
        }
    }

    @Override
    public void waitForGate(String gateName) throws TimeoutException, InterruptedException {
        this.waitForGate(gateName, GeodeAwaitility.getTimeout().toMinutes(), TimeUnit.MINUTES);
    }

    @Override
    public void waitForGate(String gateName, long timeout, TimeUnit units) throws TimeoutException, InterruptedException {
        try {
            this.blackboard.waitForGate(gateName, timeout, units);
        }
        catch (RemoteException e) {
            throw new RuntimeException("remote call failed", e);
        }
    }

    @Override
    public void clearGate(String gateName) {
        try {
            this.blackboard.clearGate(gateName);
        }
        catch (RemoteException e) {
            throw new RuntimeException("remote call failed", e);
        }
    }

    @Override
    public boolean isGateSignaled(String gateName) {
        try {
            return this.blackboard.isGateSignaled(gateName);
        }
        catch (RemoteException e) {
            throw new RuntimeException("remote call failed", e);
        }
    }

    public void setMailbox(String boxName, Object value) {
        try {
            this.blackboard.setMailbox(boxName, value);
        }
        catch (RemoteException e) {
            throw new RuntimeException("remote call failed", e);
        }
    }

    @Override
    public <T> T getMailbox(String boxName) {
        try {
            return this.blackboard.getMailbox(boxName);
        }
        catch (RemoteException e) {
            throw new RuntimeException("remote call failed", e);
        }
    }

    public InternalBlackboard internal() {
        return this.blackboard;
    }
}

