/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.internal.cli.domain.Stock;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.junit.categories.OQLIndexTest;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.MemberStarterRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={OQLIndexTest.class})
public class ListIndexCommandDistributedTestBase {
    private static final String REGION_1 = "REGION1";
    private static final String INDEX_REGION_NAME = "/REGION1";
    private static final String INDEX_1 = "INDEX1";
    private MemberVM server;
    @Rule
    public ClusterStartupRule lsRule = new ClusterStartupRule();
    @Rule
    public GfshCommandRule gfsh = new GfshCommandRule();

    @Before
    public void before() throws Exception {
        MemberVM locator = this.lsRule.startLocatorVM(0, MemberStarterRule::withHttpService);
        this.server = this.lsRule.startServerVM(1, locator.getPort());
        this.server.invoke(() -> {
            InternalCache cache = ClusterStartupRule.getCache();
            RegionFactory factory = cache.createRegionFactory(RegionShortcut.REPLICATE);
            Region region = factory.create(REGION_1);
            cache.getQueryService().createIndex(INDEX_1, "key", INDEX_REGION_NAME);
            region.put((Object)1, (Object)new Stock("SUNW", 10.0));
            region.get((Object)1);
        });
        this.connectGfsh(locator);
    }

    public void connectGfsh(MemberVM vm) throws Exception {
        this.gfsh.connectAndVerify(vm.getJmxPort(), GfshCommandRule.PortType.jmxManager, new String[0]);
    }

    @Test
    public void testListIndexes() {
        this.gfsh.executeAndAssertThat("list indexes").statusIsSuccess().hasTableSection().hasColumn("Member Name").containsExactlyInAnyOrder((Object[])new String[]{this.server.getName()});
    }

    @Test
    public void testListIndexesWithStats() {
        this.gfsh.executeAndAssertThat("list indexes --with-stats").statusIsSuccess().hasTableSection().hasColumn("Member Name").containsExactlyInAnyOrder((Object[])new String[]{this.server.getName()}).hasColumn("Updates").containsExactlyInAnyOrder((Object[])new String[]{"1"}).hasColumn("Keys").containsExactlyInAnyOrder((Object[])new String[]{"1"}).hasColumn("Values").containsExactlyInAnyOrder((Object[])new String[]{"1"});
    }
}

