/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.AvailablePortHelper;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.test.awaitility.GeodeAwaitility;
import org.apache.geode.test.junit.rules.MemberStarterRule;
import org.apache.geode.test.junit.rules.Server;

public class ServerStarterRule
extends MemberStarterRule<ServerStarterRule>
implements Server {
    private final int availableLocatorPort;
    private transient InternalCache cache;
    private transient List<CacheServer> servers = new ArrayList<CacheServer>();
    private int embeddedLocatorPort = -1;
    private boolean pdxPersistent = false;
    private boolean pdxPersistentUserSet = false;
    private PdxSerializer pdxSerializer = null;
    private boolean pdxReadSerialized = false;
    private boolean pdxReadSerializedUserSet = false;
    private int serverCount = 1;
    private final Map<String, RegionShortcut> regions = new HashMap<String, RegionShortcut>();

    public ServerStarterRule() {
        String workerID = System.getProperty("org.gradle.test.worker");
        Path wd = Paths.get(".", new String[0]).toAbsolutePath();
        String className = this.getClass().getSimpleName();
        this.availableLocatorPort = AvailablePortHelper.getRandomAvailableTCPPort();
    }

    @Override
    public InternalCache getCache() {
        return this.cache;
    }

    @Override
    public CacheServer getServer() {
        return this.servers.get(0);
    }

    public List<CacheServer> getServers() {
        return this.servers;
    }

    @Override
    public void before() {
        super.before();
        if (this.autoStart) {
            this.startServer();
            this.regions.forEach((regionName, regionType) -> {
                RegionFactory rf = this.getCache().createRegionFactory(regionType);
                rf.create(regionName);
            });
        }
    }

    @Override
    public void stopMember() {
        for (CacheServer server : this.servers) {
            server.stop();
        }
        this.cache = GemFireCacheImpl.getInstance();
        if (this.cache != null) {
            try {
                this.cache.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.cache = null;
            }
        }
        this.servers.clear();
    }

    public ServerStarterRule withPDXPersistent() {
        this.pdxPersistent = true;
        this.pdxPersistentUserSet = true;
        return this;
    }

    public ServerStarterRule withPDXReadSerialized() {
        this.pdxReadSerialized = true;
        this.pdxReadSerializedUserSet = true;
        return this;
    }

    public ServerStarterRule withPdxSerializer(PdxSerializer pdxSerializer) {
        this.pdxSerializer = pdxSerializer;
        return this;
    }

    public ServerStarterRule withNoCacheServer() {
        this.serverCount = 0;
        return this;
    }

    public ServerStarterRule withServerCount(int serverCount) {
        this.serverCount = serverCount;
        return this;
    }

    public ServerStarterRule withEmbeddedLocator() {
        this.embeddedLocatorPort = this.availableLocatorPort;
        this.properties.setProperty("start-locator", "localhost[" + this.embeddedLocatorPort + "]");
        return this;
    }

    public ServerStarterRule withRestService() {
        return this.withRestService(false);
    }

    public ServerStarterRule withRestService(boolean useDefaultPort) {
        this.withHttpService(useDefaultPort);
        this.properties.setProperty("start-dev-rest-api", "true");
        return this;
    }

    @Override
    protected void normalizeProperties() {
        super.normalizeProperties();
        if (this.httpPort < 0 && "true".equalsIgnoreCase(this.properties.getProperty("start-dev-rest-api"))) {
            this.withRestService();
        }
    }

    public ServerStarterRule withRegion(RegionShortcut type, String name) {
        this.autoStart = true;
        this.regions.put(name, type);
        return this;
    }

    public void startServer(Properties properties, int locatorPort) {
        ((ServerStarterRule)((ServerStarterRule)this.withProperties(properties)).withConnectionToLocator(locatorPort)).startServer();
    }

    public void startServer() {
        if (this.servers == null) {
            this.servers = new ArrayList<CacheServer>();
        }
        CacheFactory cf = new CacheFactory(this.properties);
        if (this.pdxPersistentUserSet) {
            cf.setPdxPersistent(this.pdxPersistent);
        }
        if (this.pdxReadSerializedUserSet) {
            cf.setPdxReadSerialized(this.pdxReadSerialized);
        }
        if (this.pdxSerializer != null) {
            cf.setPdxSerializer(this.pdxSerializer);
        }
        this.cache = (InternalCache)cf.create();
        DistributionConfig config = ((InternalDistributedSystem)this.cache.getDistributedSystem()).getConfig();
        this.jmxPort = config.getJmxManagerPort();
        this.httpPort = config.getHttpServicePort();
        for (int i = 0; i < this.serverCount; ++i) {
            CacheServer server = this.cache.addCacheServer();
            if (i == 0) {
                CacheServerHelper.setIsDefaultServer((CacheServer)server);
            }
            if (this.serverCount == 1) {
                server.setPort(this.memberPort);
            } else {
                server.setPort(0);
            }
            try {
                server.start();
            }
            catch (IOException e) {
                throw new RuntimeException("unable to start server", e);
            }
            this.memberPort = server.getPort();
            this.servers.add(server);
        }
    }

    @Override
    public int getEmbeddedLocatorPort() {
        return this.embeddedLocatorPort;
    }

    @Override
    public void waitTilFullyReconnected() {
        try {
            GeodeAwaitility.await().until(() -> {
                InternalDistributedSystem internalDistributedSystem = InternalDistributedSystem.getConnectedInstance();
                return internalDistributedSystem != null && internalDistributedSystem.getCache() != null && !internalDistributedSystem.getCache().getCacheServers().isEmpty();
            });
        }
        catch (Exception e) {
            InternalDistributedSystem ids = InternalDistributedSystem.getConnectedInstance();
            System.out.println("ds is: " + (ids != null ? "not null" : "null"));
            System.out.println("cache is: " + (ids.getCache() != null ? "not null" : "null"));
            System.out.println("has cache server: " + !ids.getCache().getCacheServers().isEmpty());
            throw e;
        }
        InternalDistributedSystem dm = InternalDistributedSystem.getConnectedInstance();
        this.cache = dm.getCache();
    }
}

