/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.geode.internal.membership.utils.AvailablePort;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.internal.ChildVM;
import org.apache.geode.test.dunit.internal.ChildVMLauncher;
import org.apache.geode.test.dunit.internal.DUnitLauncher;
import org.apache.geode.test.dunit.internal.ProcessHolder;
import org.apache.geode.test.dunit.internal.RemoteDUnitVMIF;
import org.apache.geode.test.process.JavaModuleHelper;
import org.apache.geode.test.version.VersionManager;
import org.apache.geode.test.version.VmConfiguration;

class ProcessManager
implements ChildVMLauncher {
    private final int namingPort;
    private final Map<Integer, ProcessHolder> processes = new HashMap<Integer, ProcessHolder>();
    private File log4jConfig;
    private int pendingVMs;
    private final Registry registry;
    private int debugPort = Integer.getInteger("dunit.debug.basePort", 0);
    private final int suspendVM = Integer.getInteger("dunit.debug.suspendVM", -100);
    private final VersionManager versionManager = VersionManager.getInstance();

    public ProcessManager(int namingPort, Registry registry) {
        this.namingPort = namingPort;
        this.registry = registry;
    }

    public synchronized void launchVM(int vmNum) throws IOException {
        this.launchVM(VmConfiguration.current(), vmNum, false, 0);
    }

    @Override
    public synchronized ProcessHolder launchVM(VmConfiguration vmConfiguration, int vmNum, boolean bouncedVM, int remoteStubPort) throws IOException {
        if (bouncedVM) {
            this.processes.remove(vmNum);
        }
        if (this.processes.containsKey(vmNum)) {
            throw new IllegalStateException("VM " + vmNum + " is already running.");
        }
        String version = vmConfiguration.geodeVersion().toString();
        File workingDir = ProcessManager.getVMDir(version, vmNum);
        if (!workingDir.exists()) {
            workingDir.mkdirs();
        } else if (!bouncedVM || DUnitLauncher.MAKE_NEW_WORKING_DIRS) {
            try {
                FileUtils.deleteDirectory((File)workingDir);
            }
            catch (IOException e) {
                System.err.println("Unable to delete " + workingDir + ". Currently contains " + Arrays.asList(workingDir.list()));
            }
            workingDir.mkdirs();
        }
        Object[] cmd = this.buildJavaCommand(vmNum, this.namingPort, vmConfiguration, remoteStubPort);
        System.out.println("Executing " + Arrays.toString(cmd));
        if (this.log4jConfig != null) {
            FileUtils.copyFileToDirectory((File)this.log4jConfig, (File)workingDir);
        }
        try {
            String[] envp = null;
            if (!VersionManager.isCurrentVersion((String)version)) {
                envp = new String[]{"GEODE_HOME=" + this.versionManager.getInstall(version)};
            }
            Process process = Runtime.getRuntime().exec((String[])cmd, envp, workingDir);
            ++this.pendingVMs;
            ProcessHolder holder = new ProcessHolder(process);
            this.processes.put(vmNum, holder);
            this.linkStreams(version, vmNum, holder, holder.getErrorStream(), System.err);
            this.linkStreams(version, vmNum, holder, holder.getInputStream(), System.out);
            return holder;
        }
        catch (Error | RuntimeException t) {
            t.printStackTrace();
            throw t;
        }
    }

    public void validateVersion(String version) {
        if (!this.versionManager.isValidVersion(version)) {
            throw new IllegalArgumentException("Version " + version + " is not configured for use");
        }
    }

    public static File getVMDir(String version, int vmNum) {
        return new File("dunit", VM.getVMName("10240.0.0", vmNum));
    }

    public synchronized void killVMs() {
        for (ProcessHolder process : this.processes.values()) {
            if (process == null) continue;
            process.kill();
        }
    }

    public synchronized boolean hasLiveVMs() {
        for (ProcessHolder process : this.processes.values()) {
            if (process == null || !process.isAlive()) continue;
            return true;
        }
        return false;
    }

    private void linkStreams(String version, int vmNum, final ProcessHolder holder, final InputStream in, final PrintStream out) {
        final String vmName = "[" + VM.getVMName(version, vmNum) + "] ";
        Thread ioTransport = new Thread(){

            @Override
            public void run() {
                block5: {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    try {
                        String line = reader.readLine();
                        while (line != null) {
                            if (line.length() == 0) {
                                out.println();
                            } else {
                                out.print(vmName);
                                out.println(line);
                            }
                            line = reader.readLine();
                        }
                    }
                    catch (Exception e) {
                        if (holder.isKilled()) break block5;
                        out.println("Error transporting IO from child process");
                        e.printStackTrace(out);
                    }
                }
            }
        };
        ioTransport.setDaemon(true);
        ioTransport.start();
    }

    private String removeModulesFromPath(String classpath, String ... modules) {
        for (String module : modules) {
            classpath = this.removeModuleFromGradlePath(classpath, module);
            classpath = this.removeModuleFromEclipsePath(classpath, module);
            classpath = this.removeModuleFromIntelliJPath(classpath, module);
        }
        return classpath;
    }

    private String removeModuleFromEclipsePath(String classpath, String module) {
        String buildDir = File.separator + module + File.separator + "out" + File.separator;
        String mainClasses = buildDir + "production";
        if (!classpath.contains(mainClasses)) {
            return classpath;
        }
        classpath = this.removeFromPath(classpath, mainClasses);
        return classpath;
    }

    private String removeModuleFromIntelliJPath(String p_classpath, String module) {
        String classpath = p_classpath;
        String mainClasses = File.separator + "out" + File.separator + "production" + File.separator + "org.apache.geode." + module + ".main";
        if (classpath.contains(mainClasses)) {
            classpath = this.removeFromPath(classpath, mainClasses);
        }
        if (classpath.contains(mainClasses = File.separator + "out" + File.separator + "production" + File.separator + "geode." + module + ".main")) {
            classpath = this.removeFromPath(classpath, mainClasses);
        }
        return classpath;
    }

    private String removeModuleFromGradlePath(String classpath, String module) {
        String buildDir = File.separator + module + File.separator + "build" + File.separator;
        String mainClasses = buildDir + "classes" + File.separator + "java" + File.separator + "main";
        classpath = this.removeFromPath(classpath, mainClasses);
        String libDir = buildDir + "libs";
        classpath = this.removeFromPath(classpath, libDir);
        String mainResources = buildDir + "resources" + File.separator + "main";
        classpath = this.removeFromPath(classpath, mainResources);
        String generatedResources = buildDir + "generated-resources" + File.separator + "main";
        classpath = this.removeFromPath(classpath, generatedResources);
        return classpath;
    }

    private String[] buildJavaCommand(int vmNum, int namingPort, VmConfiguration configuration, int remoteStubPort) throws IOException {
        String classPath;
        Path javaCommand = configuration.javaVersion().home().resolve("bin").resolve("java");
        String dunitClasspath = System.getProperty("java.class.path");
        String separator = File.separator;
        String geodeVersion = configuration.geodeVersion().toString();
        if (VersionManager.isCurrentVersion((String)geodeVersion)) {
            classPath = dunitClasspath;
        } else {
            dunitClasspath = this.removeModulesFromPath(dunitClasspath, "geode-common", "geode-core", "geode-cq", "geode-http-service", "geode-json", "geode-log4j", "geode-lucene", "geode-serialization", "geode-wan", "geode-gfsh");
            classPath = this.versionManager.getClasspath(geodeVersion) + File.pathSeparator + dunitClasspath;
        }
        String jreLib = separator + "jre" + separator + "lib" + separator;
        classPath = this.removeFromPath(classPath, jreLib);
        String agent = this.getAgentString();
        String jdkDebug = "";
        if (this.debugPort > 0) {
            jdkDebug = jdkDebug + ",address=" + this.debugPort;
            ++this.debugPort;
        }
        String jdkSuspend = vmNum == this.suspendVM ? "y" : "n";
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(javaCommand.toString());
        cmds.add("-classpath");
        cmds.add(this.createPathingJar(ProcessManager.getVMDir(geodeVersion, vmNum).getName(), classPath).toString());
        cmds.add("-DDUnitLauncher.REMOTE_STUB_PORT=" + remoteStubPort);
        cmds.add("-Dgemfire.DUnitLauncher.RMI_PORT=" + namingPort);
        cmds.add("-Dgemfire.DUnitLauncher.VM_NUM=" + vmNum);
        cmds.add("-Dgemfire.DUnitLauncher.VM_VERSION=" + geodeVersion);
        cmds.add("-DWORKSPACE_DIR=" + new File(".").getAbsolutePath());
        cmds.add("-DAvailablePort.lowerBound=" + AvailablePort.AVAILABLE_PORTS_LOWER_BOUND);
        cmds.add("-DAvailablePort.upperBound=" + AvailablePort.AVAILABLE_PORTS_UPPER_BOUND);
        String membershipPortRange = System.getProperty("gemfire.membership-port-range");
        if (membershipPortRange != null) {
            cmds.add(String.format("-D%s=%s", "gemfire.membership-port-range", membershipPortRange));
        }
        if (vmNum >= 0) {
            if (geodeVersion.equals("10240.0.0")) {
                cmds.add("-DLocator.inhibitDMBanner=true");
            }
        } else {
            cmds.add("-Dgemfire.enable-network-partition-detection=false");
            cmds.add("-Dgemfire.allow_old_members_to_join_for_testing=true");
        }
        if (DUnitLauncher.LOG4J != null) {
            cmds.add("-Dlog4j.configurationFile=" + DUnitLauncher.LOG4J);
        }
        cmds.add("-Djava.library.path=" + System.getProperty("java.library.path"));
        cmds.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=" + jdkSuspend + jdkDebug);
        cmds.add("-XX:+HeapDumpOnOutOfMemoryError");
        cmds.add("-Xmx512m");
        cmds.add("-Dgemfire.DEFAULT_MAX_OPLOG_SIZE=10");
        cmds.add("-Dgemfire.disallowMcastDefaults=true");
        cmds.add("-Dgemfire.use-ephemeral-ports=true");
        cmds.add("-Dgemfire.validate-serializable-objects=true");
        cmds.add("-ea");
        cmds.add("-XX:MetaspaceSize=512m");
        cmds.add("-XX:SoftRefLRUPolicyMSPerMB=1");
        cmds.add(agent);
        if (configuration.javaVersion().specificationVersion() >= 11) {
            cmds.addAll(JavaModuleHelper.getJvmModuleOptions());
        }
        cmds.add(ChildVM.class.getName());
        String[] rst = new String[cmds.size()];
        cmds.toArray(rst);
        return rst;
    }

    private Path createPathingJar(String vmName, String classPath) throws IOException {
        Path currentWorkingDir = Paths.get("", new String[0]).toAbsolutePath();
        Path pathingJarPath = currentWorkingDir.resolve(vmName + "-pathing.jar");
        List<String> originalClassPathEntries = Arrays.asList(classPath.split(File.pathSeparator));
        String classPathAttributeValue = originalClassPathEntries.stream().map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(currentWorkingDir::relativize).map(p -> Files.isDirectory(p, new LinkOption[0]) ? p + "/" : p.toString()).map(s -> s.replaceAll("\\\\", "/")).collect(Collectors.joining(" "));
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        mainAttributes.putValue(Attributes.Name.CLASS_PATH.toString(), classPathAttributeValue);
        FileOutputStream fileOutputStream = new FileOutputStream(pathingJarPath.toFile());
        JarOutputStream jarOutputStreamStream = new JarOutputStream((OutputStream)fileOutputStream, manifest);
        jarOutputStreamStream.close();
        return pathingJarPath;
    }

    private String removeFromPath(String classpath, String partialPath) {
        String[] jars = classpath.split(File.pathSeparator);
        StringBuilder sb = new StringBuilder(classpath.length());
        Boolean firstjar = true;
        for (String jar : jars) {
            if (jar.contains(partialPath)) continue;
            if (!firstjar.booleanValue()) {
                sb.append(File.pathSeparator);
            }
            sb.append(jar);
            firstjar = false;
        }
        return sb.toString();
    }

    private String getAgentString() {
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        if (runtimeBean != null) {
            for (String arg : runtimeBean.getInputArguments()) {
                if (!arg.contains("-javaagent:")) continue;
                arg = arg.replace("-javaagent:..", "-javaagent:" + System.getProperty("user.dir") + File.separator + "..");
                arg = arg.replace("destfile=..", "destfile=" + System.getProperty("user.dir") + File.separator + "..");
                return arg;
            }
        }
        return "-DdummyArg=true";
    }

    synchronized void signalVMReady() {
        --this.pendingVMs;
        this.notifyAll();
    }

    public synchronized boolean waitForVMs() throws InterruptedException {
        return this.waitForVMs(120000L);
    }

    public synchronized boolean waitForVMs(long timeout) throws InterruptedException {
        long end = System.currentTimeMillis() + timeout;
        while (this.pendingVMs > 0) {
            long remaining = end - System.currentTimeMillis();
            if (remaining <= 0L) {
                return false;
            }
            this.wait(remaining);
        }
        return true;
    }

    @Override
    public RemoteDUnitVMIF getStub(int i) throws RemoteException, NotBoundException, InterruptedException {
        return this.getStub("10240.0.0", i);
    }

    public RemoteDUnitVMIF getStub(String version, int i) throws RemoteException, NotBoundException, InterruptedException {
        this.waitForVMs(120000L);
        return (RemoteDUnitVMIF)this.registry.lookup("vm" + i);
    }

    public ProcessHolder getProcessHolder(int i) {
        return this.processes.get(i);
    }
}

