/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.MemberStarterRule;
import org.apache.geode.test.junit.rules.serializable.SerializableTemporaryFolder;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ExportLogsStatsDistributedTestBase {
    @ClassRule
    public static ClusterStartupRule lsRule = new ClusterStartupRule().withLogFile();
    @ClassRule
    public static GfshCommandRule connector = new GfshCommandRule();
    @Rule
    public SerializableTemporaryFolder tempFolderRule = new SerializableTemporaryFolder();
    protected static Set<String> expectedZipEntries = new HashSet<String>();
    protected static MemberVM locator;

    @BeforeClass
    public static void beforeClass() {
        locator = lsRule.startLocatorVM(0, MemberStarterRule::withHttpService);
        Properties serverProperties = new Properties();
        serverProperties.setProperty("statistic-sampling-enabled", "true");
        serverProperties.setProperty("statistic-archive-file", "statistics.gfs");
        lsRule.startServerVM(1, serverProperties, locator.getPort());
        expectedZipEntries = Sets.newHashSet((Object[])new String[]{"locator-0" + File.separator + "locator-0.log", "server-1" + File.separator + "server-1.log", "server-1" + File.separator + "statistics.gfs"});
    }

    protected void connectIfNeeded() throws Exception {
        if (!connector.isConnected()) {
            connector.connect(locator, new String[0]);
        }
    }

    @Test
    public void testExportLogsAndStats() throws Exception {
        this.connectIfNeeded();
        String tempFolder = this.tempFolderRule.getRoot().getAbsolutePath();
        connector.executeAndAssertThat("export logs --dir=" + tempFolder).statusIsSuccess();
        String zipPath = this.getZipPathFromCommandResult(connector.getGfshOutput());
        Set<String> actualZipEntries = ExportLogsStatsDistributedTestBase.getZipEntries(zipPath);
        HashSet expectedFiles = Sets.newHashSet((Object[])new String[]{"locator-0" + File.separator + "locator-0.log", "server-1" + File.separator + "server-1.log", "server-1" + File.separator + "statistics.gfs"});
        Assertions.assertThat(actualZipEntries).containsAll((Iterable)expectedFiles);
        actualZipEntries = actualZipEntries.stream().filter(x -> !x.endsWith("pulse.log")).collect(Collectors.toSet());
        Assertions.assertThat(actualZipEntries).hasSize(3);
    }

    @Test
    public void testExportLogsOnly() throws Exception {
        this.connectIfNeeded();
        String tempFolder = this.tempFolderRule.getRoot().getAbsolutePath();
        connector.executeAndAssertThat("export logs --logs-only --dir=" + tempFolder).statusIsSuccess();
        String zipPath = this.getZipPathFromCommandResult(connector.getGfshOutput());
        Set<String> actualZipEntries = ExportLogsStatsDistributedTestBase.getZipEntries(zipPath);
        HashSet expectedFiles = Sets.newHashSet((Object[])new String[]{"locator-0" + File.separator + "locator-0.log", "server-1" + File.separator + "server-1.log"});
        Assertions.assertThat(actualZipEntries).containsAll((Iterable)expectedFiles);
        actualZipEntries = actualZipEntries.stream().filter(x -> !x.endsWith("pulse.log")).collect(Collectors.toSet());
        Assertions.assertThat(actualZipEntries).hasSize(2);
    }

    @Test
    public void testExportStatsOnly() throws Exception {
        this.connectIfNeeded();
        String tempFolder = this.tempFolderRule.getRoot().getAbsolutePath();
        connector.executeAndAssertThat("export logs --stats-only --dir=" + tempFolder).statusIsSuccess();
        String zipPath = this.getZipPathFromCommandResult(connector.getGfshOutput());
        Set<String> actualZipEntries = ExportLogsStatsDistributedTestBase.getZipEntries(zipPath);
        HashSet expectedFiles = Sets.newHashSet((Object[])new String[]{"server-1" + File.separator + "statistics.gfs"});
        Assertions.assertThat(actualZipEntries).isEqualTo((Object)expectedFiles);
    }

    @Test
    public void startAndEndDateCanExcludeLogs() throws Exception {
        this.connectIfNeeded();
        ZonedDateTime now = LocalDateTime.now().atZone(ZoneId.systemDefault());
        ZonedDateTime tomorrow = now.plusDays(1L);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");
        CommandStringBuilder commandStringBuilder = new CommandStringBuilder("export logs");
        commandStringBuilder.addOption("start-time", dateTimeFormatter.format(tomorrow));
        commandStringBuilder.addOption("log-level", "debug");
        connector.executeAndAssertThat(commandStringBuilder.toString()).statusIsError().containsOutput(new String[]{"No files to be exported"});
    }

    @Test
    public void testExportedZipFileTooBig() throws Exception {
        this.connectIfNeeded();
        connector.executeAndAssertThat("export logs --file-size-limit=10k").statusIsError();
    }

    protected String getZipPathFromCommandResult(String message) {
        return message.replaceAll("Logs exported to the connected member's file system: ", "").trim();
    }

    private static Set<String> getZipEntries(String zipFilePath) throws IOException {
        return new ZipFile(zipFilePath).stream().map(ZipEntry::getName).filter(x -> !x.endsWith("views.log")).collect(Collectors.toSet());
    }
}

