/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.io.Serializable;
import java.util.Objects;
import org.apache.geode.cache.EntryOperation;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.internal.cache.execute.data.CustId;
import org.apache.geode.internal.cache.execute.data.OrderId;
import org.apache.geode.internal.cache.execute.data.ShipmentId;

public class CustomerIDPartitionResolver
implements PartitionResolver {
    private static final CustomerIDPartitionResolver customerIDPartitionResolver = null;
    private String id;
    private String resolverName;

    public CustomerIDPartitionResolver() {
    }

    public CustomerIDPartitionResolver(String resolverID) {
        this.id = resolverID;
    }

    public String getName() {
        return this.resolverName;
    }

    public Serializable getRoutingObject(EntryOperation opDetails) {
        Object routingbject = null;
        if (opDetails.getKey() instanceof ShipmentId) {
            ShipmentId shipmentId = (ShipmentId)opDetails.getKey();
            routingbject = shipmentId.getOrderId().getCustId();
        }
        if (opDetails.getKey() instanceof OrderId) {
            OrderId orderId = (OrderId)opDetails.getKey();
            routingbject = orderId.getCustId();
        } else if (opDetails.getKey() instanceof CustId) {
            CustId custId = (CustId)opDetails.getKey();
            routingbject = custId.getCustId();
        }
        return routingbject;
    }

    public void close() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomerIDPartitionResolver)) {
            return false;
        }
        CustomerIDPartitionResolver otherCustomerIDPartitionResolver = (CustomerIDPartitionResolver)o;
        return otherCustomerIDPartitionResolver.id.equals(this.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }
}

