/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.InvalidClassException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.data.Portfolio;
import org.apache.geode.internal.cache.EvictionAttributesImpl;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.test.dunit.IgnoredException;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.apache.geode.test.junit.rules.LocatorStarterRule;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public abstract class QueryCommandDUnitTestBase {
    private static final String SERIALIZATION_FILTER = Value.class.getName();
    private static final String REGION_NAME = "region";
    private static final String REGION_NAME_PATH = "/region";
    private static final String REGION_EVICTION_NAME = "regionWithEviction";
    private static final String REGION_EVICTION_NAME_PATH = "/regionWithEviction";
    private static final String REGION_PROXY_NAME = "regionWithProxy";
    private static final String REGION_PROXY_NAME_PATH = "/regionWithProxy";
    private static final String PARTITIONED_REGION_NAME = "partitionedRegion";
    private static final String PARTITIONED_REGION_NAME_PATH = "/partitionedRegion";
    private static final int MAX_RANDOM_INTEGER = 5;
    protected MemberVM locator;
    protected MemberVM server1;
    protected MemberVM server2;
    @Rule
    public GfshCommandRule gfsh = new GfshCommandRule();
    @Rule
    public ClusterStartupRule cluster = new ClusterStartupRule();

    @Before
    public void setUp() throws Exception {
        Properties locatorProps = this.locatorProperties();
        this.locator = this.cluster.startLocatorVM(0, l -> (LocatorStarterRule)((LocatorStarterRule)l.withHttpService()).withProperties(locatorProps));
        this.server1 = this.cluster.startServerVM(1, this.serverProperties(), this.locator.getPort());
        this.server2 = this.cluster.startServerVM(2, this.serverProperties(), this.locator.getPort());
        this.server1.invoke(() -> QueryCommandDUnitTestBase.createReplicatedRegion(REGION_NAME));
        this.server2.invoke(() -> QueryCommandDUnitTestBase.createReplicatedRegion(REGION_NAME));
        this.server1.invoke(() -> QueryCommandDUnitTestBase.createPartitionedRegion(PARTITIONED_REGION_NAME));
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(REGION_NAME_PATH, 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(PARTITIONED_REGION_NAME_PATH, 1);
        this.connectToLocator();
    }

    protected abstract Properties locatorProperties(Properties var1);

    protected abstract void connectToLocator() throws Exception;

    private Properties locatorProperties() {
        Properties configProperties = new Properties();
        configProperties.setProperty("serializable-object-filter", SERIALIZATION_FILTER);
        return this.locatorProperties(configProperties);
    }

    private Properties serverProperties() {
        Properties configProperties = new Properties();
        configProperties.setProperty("serializable-object-filter", SERIALIZATION_FILTER);
        return configProperties;
    }

    @Test
    public void testWithGfshEnvironmentVariables() {
        this.gfsh.executeAndAssertThat("set variable --name=DATA_REGION --value=/region").statusIsSuccess();
        this.gfsh.executeAndAssertThat("set variable --name=PORTFOLIO_ID --value=3").statusIsSuccess();
        this.gfsh.executeAndAssertThat("set variable --name=STATUS --value=inactive").statusIsSuccess();
        String query = "query --query=\"select ID , status , createTime , pk, floatMinValue from ${DATA_REGION} where ID <= ${PORTFOLIO_ID} and status=${STATUS}\" --interactive=false";
        this.gfsh.executeAndAssertThat(query).statusIsSuccess();
    }

    @Test
    public void testWithUnsetGfshEnvironmentVariables() {
        IgnoredException.addIgnoredException(QueryInvalidException.class);
        String query = "query --query=\"select ID , status , createTime , pk, floatMinValue from ${UNSET_REGION} where ID <= ${UNSET_PORTFOLIO_ID} and status=${UNSET_STATUS}\" --interactive=false";
        this.gfsh.executeAndAssertThat(query).statusIsError().containsOutput(new String[]{String.format("Syntax error in query: %s", "")});
    }

    @Test
    public void testSimpleQuery() {
        this.server1.invoke(() -> QueryCommandDUnitTestBase.setUpDataForRegion(PARTITIONED_REGION_NAME_PATH));
        int randomInteger = new Random(System.nanoTime()).nextInt(5);
        String query = "query --query=\"select ID , status , createTime , pk, floatMinValue from /partitionedRegion where ID <= " + randomInteger + "\" --interactive=false";
        CommandResult commandResult = this.gfsh.executeCommand(query);
        QueryCommandDUnitTestBase.validateSelectResult(commandResult, true, randomInteger + 1, "ID", "status", "createTime", "pk", "floatMinValue");
    }

    @Test
    public void testSimpleQueryOnLocator() {
        this.server1.invoke(() -> QueryCommandDUnitTestBase.setUpDataForRegion(PARTITIONED_REGION_NAME_PATH));
        this.locator.invoke(() -> {
            String query = "query --query=\"select ID , status , createTime , pk, floatMinValue from /partitionedRegion where ID <= 4\" --interactive=false";
            String result = QueryCommandDUnitTestBase.getMemberMXBean().processCommand(query);
            Assertions.assertThat((String)result).contains(new CharSequence[]{"ID"});
            Assertions.assertThat((String)result).contains(new CharSequence[]{"status"});
            Assertions.assertThat((String)result).contains(new CharSequence[]{"createTime"});
            Assertions.assertThat((String)result).contains(new CharSequence[]{"pk"});
            Assertions.assertThat((String)result).contains(new CharSequence[]{"floatMinValue"});
            Assertions.assertThat((String)result).contains(new CharSequence[]{"\"Rows\":\"5\""});
        });
    }

    @Test
    public void testQueryEvictedDataDeserializable() {
        this.server1.invoke(() -> QueryCommandDUnitTestBase.createReplicatedRegionWithEviction(REGION_EVICTION_NAME));
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(REGION_EVICTION_NAME_PATH, 1);
        this.server1.invoke(() -> QueryCommandDUnitTestBase.setUpDeserializableDataForRegion(REGION_EVICTION_NAME_PATH));
        String query = "query --query=\"select Value from /regionWithEviction\" --interactive=false";
        CommandResult commandResult = this.gfsh.executeCommand(query);
        QueryCommandDUnitTestBase.validateSelectResult(commandResult, true, 10, "Value");
    }

    @Test
    public void testQueryEvictedDataNotDeserializable() {
        IgnoredException.addIgnoredException(InvalidClassException.class);
        this.server1.invoke(() -> QueryCommandDUnitTestBase.createReplicatedRegionWithEviction(REGION_EVICTION_NAME));
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(REGION_EVICTION_NAME_PATH, 1);
        this.server1.invoke(() -> QueryCommandDUnitTestBase.setUpNotDeserializableDataForRegion(REGION_EVICTION_NAME_PATH));
        String query = "query --query=\"select Value from /regionWithEviction\" --interactive=false";
        CommandResult commandResult = this.gfsh.executeCommand(query);
        QueryCommandDUnitTestBase.validateSelectResult(commandResult, false, -1, "Value");
        Assertions.assertThat((String)commandResult.asString()).contains(new CharSequence[]{"An IOException was thrown while deserializing"});
    }

    @Test
    public void testSimpleQueryWithProxyRegion() {
        this.server1.invoke(() -> QueryCommandDUnitTestBase.createReplicatedProxyRegion(REGION_PROXY_NAME));
        this.server2.invoke(() -> QueryCommandDUnitTestBase.createReplicatedRegion(REGION_PROXY_NAME));
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(REGION_PROXY_NAME_PATH, 2);
        this.server1.invoke(() -> QueryCommandDUnitTestBase.setUpDataForRegion(REGION_PROXY_NAME_PATH));
        int randomInteger = new Random(System.nanoTime()).nextInt(5);
        String queryString = "\"select ID , status , createTime , pk, floatMinValue from /regionWithProxy where ID <= " + randomInteger + "\"";
        String command = new CommandStringBuilder("query").addOption("member", "server-2").addOption("query", queryString).getCommandString();
        CommandResult commandResult = this.gfsh.executeAndAssertThat(command).getCommandResult();
        QueryCommandDUnitTestBase.validateSelectResult(commandResult, true, randomInteger + 1, "ID", "status", "createTime", "pk", "floatMinValue");
    }

    private static void createReplicatedRegion(String regionName) {
        QueryCommandDUnitTestBase.createRegionFactory(RegionShortcut.REPLICATE).create(regionName);
    }

    private static void createReplicatedRegionWithEviction(String regionName) {
        EvictionAttributesImpl evictionAttributes = new EvictionAttributesImpl().setAction(EvictionAction.OVERFLOW_TO_DISK).setAlgorithm(EvictionAlgorithm.LRU_ENTRY).setMaximum(1);
        QueryCommandDUnitTestBase.createRegionFactory(RegionShortcut.REPLICATE).setEvictionAttributes((EvictionAttributes)evictionAttributes).create(regionName);
    }

    private static void createReplicatedProxyRegion(String regionName) {
        QueryCommandDUnitTestBase.createRegionFactory(RegionShortcut.REPLICATE_PROXY).create(regionName);
    }

    private static void createPartitionedRegion(String regionName) {
        PartitionAttributes partitionAttributes = new PartitionAttributesFactory().setRedundantCopies(2).create();
        QueryCommandDUnitTestBase.createRegionFactory(RegionShortcut.PARTITION).setPartitionAttributes(partitionAttributes).create(regionName);
    }

    private static void setUpDataForRegion(String regionPath) {
        Region region = QueryCommandDUnitTestBase.getRegion(regionPath);
        for (int index = 0; index < 10; ++index) {
            region.put((Object)index, (Object)new Portfolio(index));
        }
    }

    private static void setUpNotDeserializableDataForRegion(String regionPath) {
        Region region = QueryCommandDUnitTestBase.getRegion(regionPath);
        for (int index = 0; index < 10; ++index) {
            region.put((Object)index, (Object)new FailsSerializationFilter(index));
        }
    }

    private static void setUpDeserializableDataForRegion(String regionPath) {
        Region region = QueryCommandDUnitTestBase.getRegion(regionPath);
        for (int index = 0; index < 10; ++index) {
            region.put((Object)index, (Object)new Value(index));
        }
    }

    private static void validateSelectResult(CommandResult commandResult, boolean expectSuccess, int expectedRows, String ... columns) {
        ResultModel resultData = commandResult.getResultData();
        Map data = resultData.getDataSection("data-info").getContent();
        Assertions.assertThat((String)((String)data.get("Result"))).isEqualTo(String.valueOf(expectSuccess));
        if (expectSuccess && expectedRows != -1) {
            Assertions.assertThat((String)((String)data.get("Rows"))).isEqualTo(String.valueOf(expectedRows));
            if (expectedRows > 0 && columns != null) {
                Map table = resultData.getTableSection("query").getContent();
                Assertions.assertThat(table.keySet()).contains((Object[])columns);
            }
        }
    }

    private static MemberMXBean getMemberMXBean() {
        return QueryCommandDUnitTestBase.getManagementService().getMemberMXBean();
    }

    private static ManagementService getManagementService() {
        return ManagementService.getExistingManagementService((Cache)ClusterStartupRule.getCache());
    }

    private static <K, V> RegionFactory<K, V> createRegionFactory(RegionShortcut shortcut) {
        return Objects.requireNonNull(ClusterStartupRule.getCache()).createRegionFactory(shortcut);
    }

    private static <K, V> Region<K, V> getRegion(String regionPath) {
        return Objects.requireNonNull(ClusterStartupRule.getCache()).getRegion(regionPath);
    }

    public static class FailsSerializationFilter
    extends Value {
        public FailsSerializationFilter(int suffix) {
            super(suffix);
        }
    }

    public static class Value
    implements Serializable {
        private final String name;
        private final String lastName;
        private final String department;
        private final int age;
        private final int employeeId;

        public Value(int suffix) {
            this.employeeId = suffix;
            this.name = "Name" + suffix;
            this.lastName = "lastName" + suffix;
            this.department = "department" + suffix;
            this.age = suffix;
        }

        public boolean equals(Object other) {
            if (other instanceof Value) {
                Value value = (Value)other;
                return value.employeeId == this.employeeId;
            }
            return false;
        }

        public int hashCode() {
            return this.employeeId % 7;
        }

        public String toString() {
            return "Value [" + " name : " + this.name + " lastName : " + this.lastName + " department : " + this.department + " age : " + this.age + " employeeId : " + this.employeeId + " ]";
        }
    }
}

