/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.geode.DataSerializable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.TXId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NestedTransactionFunction
implements Function,
DataSerializable {
    private static final Logger logger = LogManager.getLogger();
    public static final int COMMIT = 1;
    public static final int ROLLBACK = 2;
    private static final long serialVersionUID = 1400965724856341543L;

    public boolean hasResult() {
        return true;
    }

    public void execute(FunctionContext context) {
        Cache cache = CacheFactory.getAnyInstance();
        ArrayList args = (ArrayList)context.getArguments();
        TXId txId = null;
        int action = 0;
        try {
            txId = (TXId)args.get(0);
            action = (Integer)args.get(1);
        }
        catch (ClassCastException e) {
            logger.info("CommitFunction should be invoked with a TransactionId as an argument i.e. setArguments(txId).execute(function)");
            throw e;
        }
        CacheTransactionManager txMgr = cache.getCacheTransactionManager();
        Boolean result = false;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (txMgr.tryResume((TransactionId)txId)) {
            if (isDebugEnabled) {
                logger.debug("CommitFunction: resumed transaction: {}", (Object)txId);
            }
            if (action == 1) {
                if (isDebugEnabled) {
                    logger.debug("CommitFunction: committing transaction: {}", (Object)txId);
                }
                txMgr.commit();
            } else if (action == 2) {
                if (isDebugEnabled) {
                    logger.debug("CommitFunction: rolling back transaction: {}", (Object)txId);
                }
                txMgr.rollback();
            } else {
                throw new IllegalStateException("unknown transaction termination action");
            }
            result = true;
        }
        if (isDebugEnabled) {
            logger.debug("CommitFunction: for transaction: {} sending result: {}", (Object)txId, (Object)result);
        }
        context.getResultSender().lastResult((Object)result);
    }

    public String getId() {
        return this.getClass().getName();
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public boolean isHA() {
        return false;
    }

    public void toData(DataOutput out) throws IOException {
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
    }
}

