/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.Cache;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.cache.xmlcache.CacheXmlGenerator;
import org.apache.geode.test.dunit.SerializableRunnableIF;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.AbstractDistributedRule;
import org.apache.geode.test.junit.rules.serializable.SerializableTemporaryFolder;
import org.assertj.core.api.Assertions;
import org.junit.rules.TemporaryFolder;

public class CacheXmlRule
extends AbstractDistributedRule {
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private static final CacheXmlCreation DUMMY = new CacheXmlCreation(null, null);
    private static final AtomicReference<ICacheXmlCreation> DELEGATE = new AtomicReference<CacheXmlCreation>(DUMMY);
    private static final SerializableRunnableIF NO_OP = new DummySerializableRunnableIF();
    private final AtomicReference<SerializableRunnableIF> createCache = new AtomicReference<SerializableRunnableIF>(NO_OP);
    private final SerializableTemporaryFolder temporaryFolder;

    public CacheXmlRule() {
        this(VM.DEFAULT_VM_COUNT);
    }

    public CacheXmlRule(int vmCount) {
        this(vmCount, new SerializableTemporaryFolder());
    }

    private CacheXmlRule(int vmCount, SerializableTemporaryFolder temporaryFolder) {
        super(vmCount);
        this.temporaryFolder = temporaryFolder;
    }

    public CacheXmlRule cacheBuilder(SerializableRunnableIF createCache) {
        this.createCache.set(createCache);
        return this;
    }

    public void beginCacheXml() {
        DELEGATE.get().beginCacheXml();
    }

    public void finishCacheXml(String name) {
        DELEGATE.get().finishCacheXml(name);
    }

    public void finishCacheXml(File root, String name, boolean useSchema, String xmlVersion) throws IOException {
        DELEGATE.get().finishCacheXml(root, name, useSchema, xmlVersion);
    }

    public InternalCache getCache() {
        InternalCache cache = DELEGATE.get().getCache();
        Assertions.assertThat((Object)cache).isInstanceOf(CacheXmlCreation.class);
        return cache;
    }

    @Override
    public void before() throws Exception {
        Method method = TemporaryFolder.class.getDeclaredMethod(BEFORE, new Class[0]);
        method.setAccessible(true);
        method.invoke((Object)this.temporaryFolder, new Object[0]);
        this.invoker().invokeInEveryVMAndController(() -> this.invokeBefore());
    }

    @Override
    public void after() {
        this.invoker().invokeInEveryVMAndController(() -> this.invokeAfter());
        try {
            Method method = TemporaryFolder.class.getDeclaredMethod(AFTER, new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this.temporaryFolder, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void afterCreateVM(VM vm) {
        vm.invoke(() -> this.invokeBefore());
    }

    @Override
    protected void afterBounceVM(VM vm) {
        vm.invoke(() -> this.invokeBefore());
    }

    private void invokeBefore() throws Exception {
        DELEGATE.set(new CacheXmlCreation(this.createCache.get(), this.temporaryFolder));
    }

    private void invokeAfter() {
        DELEGATE.set(DUMMY);
    }

    private static class DummySerializableRunnableIF
    implements SerializableRunnableIF {
        private DummySerializableRunnableIF() {
        }

        @Override
        public void run() throws Exception {
        }

        @Override
        public String getMethodName() {
            return null;
        }

        @Override
        public long getId() {
            return -1L;
        }
    }

    private static class CacheXmlCreation
    extends CacheCreation
    implements ICacheXmlCreation {
        private final AtomicBoolean closed = new AtomicBoolean();
        private final SerializableRunnableIF createCache;
        private final SerializableTemporaryFolder temporaryFolder;

        CacheXmlCreation(SerializableRunnableIF createCache, SerializableTemporaryFolder temporaryFolder) {
            this.createCache = createCache;
            this.temporaryFolder = temporaryFolder;
        }

        @Override
        public void beginCacheXml() {
        }

        @Override
        public void finishCacheXml(String name) {
            try {
                File file = this.temporaryFolder.newFile(name + "-cache.xml");
                PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(file), true);
                CacheXmlGenerator.generate((Cache)this.getCache(), (PrintWriter)printWriter);
                printWriter.close();
                this.close();
                GemFireCacheImpl.testCacheXml = file;
                this.createCache.run();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                GemFireCacheImpl.testCacheXml = null;
            }
        }

        @Override
        public void finishCacheXml(File root, String name, boolean useSchema, String xmlVersion) throws IOException {
            File dir = new File(root, "XML_" + xmlVersion);
            dir.mkdirs();
            File file = new File(dir, name + ".xml");
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(file), true);
            CacheXmlGenerator.generate((Cache)this.getCache(), (PrintWriter)printWriter, (boolean)useSchema, (String)xmlVersion);
            printWriter.close();
            this.close();
            GemFireCacheImpl.testCacheXml = file;
            try {
                this.createCache.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                GemFireCacheImpl.testCacheXml = null;
            }
        }

        @Override
        public InternalCache getCache() {
            return this;
        }

        @Override
        public void close() {
            this.closed.set(true);
        }

        public boolean isClosed() {
            return this.closed.get();
        }
    }

    private static interface ICacheXmlCreation {
        public void beginCacheXml();

        public void finishCacheXml(String var1);

        public void finishCacheXml(File var1, String var2, boolean var3, String var4) throws IOException;

        public InternalCache getCache();

        public void close();
    }
}

