/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit.rules;

import java.io.Serializable;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.VMEventListener;
import org.apache.geode.test.dunit.internal.DUnitLauncher;
import org.apache.geode.test.dunit.internal.TestHistoryLogger;
import org.apache.geode.test.dunit.rules.RemoteInvoker;
import org.apache.geode.test.junit.rules.serializable.SerializableStatement;
import org.apache.geode.test.junit.rules.serializable.SerializableTestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

class AbstractDistributedRule
implements SerializableTestRule {
    private final int vmCount;
    private final RemoteInvoker invoker;
    private volatile VMEventListener vmEventListener;

    AbstractDistributedRule() {
        this(VM.DEFAULT_VM_COUNT);
    }

    AbstractDistributedRule(int vmCount) {
        this(vmCount, new RemoteInvoker());
    }

    private AbstractDistributedRule(int vmCount, RemoteInvoker invoker) {
        this.vmCount = vmCount;
        this.invoker = invoker;
    }

    public Statement apply(final Statement base, final Description description) {
        return new SerializableStatement(){

            public void evaluate() throws Throwable {
                AbstractDistributedRule.this.beforeDistributedTest(description);
                try {
                    base.evaluate();
                }
                finally {
                    AbstractDistributedRule.this.afterDistributedTest(description);
                }
            }
        };
    }

    void beforeDistributedTest(Description description) throws Throwable {
        TestHistoryLogger.logTestHistory(description.getTestClass().getSimpleName(), description.getMethodName());
        DUnitLauncher.launchIfNeeded(this.vmCount);
        System.out.println("\n\n[setup] START TEST " + description.getClassName() + "." + description.getMethodName());
        this.vmEventListener = new InternalVMEventListener();
        VM.addVMEventListener(this.vmEventListener);
        this.before();
    }

    void afterDistributedTest(Description description) throws Throwable {
        VM.removeVMEventListener(this.vmEventListener);
        this.after();
        System.out.println("\n\n[setup] END TEST " + description.getTestClass().getSimpleName() + "." + description.getMethodName());
    }

    protected void before() throws Throwable {
    }

    protected void after() throws Throwable {
    }

    protected RemoteInvoker invoker() {
        return this.invoker;
    }

    protected int vmCount() {
        return this.vmCount;
    }

    protected void afterCreateVM(VM vm) {
    }

    protected void beforeBounceVM(VM vm) {
    }

    protected void afterBounceVM(VM vm) {
    }

    private class InternalVMEventListener
    implements VMEventListener,
    Serializable {
        private InternalVMEventListener() {
        }

        @Override
        public void afterCreateVM(VM vm) {
            AbstractDistributedRule.this.afterCreateVM(vm);
        }

        @Override
        public void beforeBounceVM(VM vm) {
            AbstractDistributedRule.this.beforeBounceVM(vm);
        }

        @Override
        public void afterBounceVM(VM vm) {
            AbstractDistributedRule.this.afterBounceVM(vm);
        }
    }
}

