/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.dunit;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.api.MembershipManagerHelper;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.test.dunit.DUnitEnv;
import org.apache.geode.test.dunit.Invoke;
import org.apache.geode.test.dunit.VM;
import org.junit.Assert;

public class DistributedTestUtils {
    protected DistributedTestUtils() {
    }

    public static void addHydraProperties(Properties properties) {
        Properties dsProperties = DUnitEnv.get().getDistributedSystemProperties();
        for (Map.Entry<Object, Object> entry : dsProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (properties.getProperty(key) != null) continue;
            properties.setProperty(key, value);
        }
    }

    public static void crashDistributedSystem(DistributedSystem system) {
        MembershipManagerHelper.crashDistributedSystem(system);
    }

    public static void crashDistributedSystem(VM ... vms) {
        for (VM vm : vms) {
            vm.invoke(() -> {
                InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
                DistributedTestUtils.crashDistributedSystem((DistributedSystem)system);
            });
        }
    }

    public static void deleteLocatorStateFile(int ... ports) {
        for (int index = 0; index < ports.length; ++index) {
            File stateFile = new File("locator" + ports[index] + "view.dat");
            if (!stateFile.exists()) continue;
            stateFile.delete();
        }
    }

    public static Properties getAllDistributedSystemProperties(Properties properties) {
        Properties dsProperties = DUnitEnv.get().getDistributedSystemProperties();
        if (!dsProperties.contains("disable-auto-reconnect")) {
            dsProperties.put("disable-auto-reconnect", "true");
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            dsProperties.put(key, value);
        }
        System.out.println("distributed system properties: " + dsProperties);
        return dsProperties;
    }

    @Deprecated
    public static int getDUnitLocatorPort() {
        return DistributedTestUtils.getLocatorPort();
    }

    public static int getLocatorPort() {
        return DUnitEnv.get().getLocatorPort();
    }

    public static String getLocators() {
        return VM.getHostName() + "[" + DistributedTestUtils.getLocatorPort() + "]";
    }

    public static void unregisterAllDataSerializersFromAllVms() {
        DistributedTestUtils.unregisterDataSerializerInThisVM();
        Invoke.invokeInEveryVM(() -> DistributedTestUtils.unregisterDataSerializerInThisVM());
        Invoke.invokeInLocator(() -> DistributedTestUtils.unregisterDataSerializerInThisVM());
    }

    public static void unregisterDataSerializerInThisVM() {
        InternalDataSerializer.reinitialize();
        Assert.assertEquals((long)0L, (long)InternalDataSerializer.getSerializers().length);
    }

    public static void unregisterInstantiatorsInThisVM() {
        InternalInstantiator.reinitialize();
        Assert.assertEquals((long)0L, (long)InternalInstantiator.getInstantiators().length);
    }
}

