/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.geode.internal.lang.SystemPropertyHelper;
import org.apache.geode.test.junit.rules.DescribedExternalResource;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.junit.runner.Description;

public class DiskDirRule
extends DescribedExternalResource {
    protected static final String BEFORE = "before";
    protected static final String AFTER = "after";
    protected static final String STARTING = "starting";
    private final TemporaryFolder temporaryFolder;
    private final TestName testName;
    private String originalValue;

    public DiskDirRule() {
        this(new TemporaryFolder(), new TestName());
    }

    protected DiskDirRule(TemporaryFolder temporaryFolder, TestName testName) {
        this.temporaryFolder = temporaryFolder;
        this.testName = testName;
    }

    public File getDiskDir() {
        return new File(System.getProperty("geode.defaultDiskDirs"));
    }

    protected void before(Description description) throws Exception {
        Optional value = SystemPropertyHelper.getProductStringProperty((String)"defaultDiskDirs");
        value.ifPresent(s -> {
            this.originalValue = s;
        });
        this.initializeHelperRules(description);
        File diskDir = this.temporaryFolder.newFolder(this.getDiskDirName(description.getClassName()));
        System.setProperty("geode.defaultDiskDirs", diskDir.getAbsolutePath());
    }

    protected void after(Description description) {
        if (this.originalValue == null) {
            System.clearProperty("geode.defaultDiskDirs");
        } else {
            System.setProperty("geode.defaultDiskDirs", this.originalValue);
        }
    }

    protected String getTestClassName(Description description) {
        return description.getTestClass().getSimpleName();
    }

    private String getDiskDirName(String testClass) {
        return testClass + "_" + this.testName.getMethodName() + "-diskDirs";
    }

    private void initializeHelperRules(Description description) throws Exception {
        Method method;
        if (this.temporaryFolder != null) {
            method = TemporaryFolder.class.getDeclaredMethod(BEFORE, new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this.temporaryFolder, new Object[0]);
        }
        if (this.testName != null) {
            method = TestName.class.getDeclaredMethod(STARTING, Description.class);
            method.setAccessible(true);
            method.invoke((Object)this.testName, description);
        }
    }
}

