/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.templates;

import java.security.Principal;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.operations.OperationContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.security.AccessControl;
import org.apache.geode.security.NotAuthorizedException;

public class SimpleAccessController
implements AccessControl {
    private static Principal principal;

    public void init(Principal principal, DistributedMember remoteMember, Cache cache) throws NotAuthorizedException {
        SimpleAccessController.principal = principal;
    }

    public static AccessControl create() {
        return new SimpleAccessController();
    }

    public boolean authorizeOperation(String regionName, OperationContext context) {
        switch (context.getOperationCode()) {
            case GET: 
            case REGISTER_INTEREST: 
            case UNREGISTER_INTEREST: 
            case CONTAINS_KEY: 
            case KEY_SET: 
            case QUERY: 
            case EXECUTE_CQ: 
            case STOP_CQ: 
            case CLOSE_CQ: {
                return this.authorize(principal, "DATA:READ");
            }
            case PUT: 
            case PUTALL: 
            case REMOVEALL: 
            case DESTROY: 
            case INVALIDATE: {
                return this.authorize(principal, "DATA:WRITE");
            }
            case REGION_CLEAR: 
            case REGION_CREATE: 
            case REGION_DESTROY: 
            case EXECUTE_FUNCTION: 
            case GET_DURABLE_CQS: {
                return false;
            }
        }
        return false;
    }

    private boolean authorize(Principal principal, String permission) {
        String[] principals;
        for (String role : principals = principal.toString().toLowerCase().split(",")) {
            String permissionString = permission.replace(":", "").toLowerCase();
            if (!permissionString.startsWith(role)) continue;
            return true;
        }
        return false;
    }

    public void close() {
        principal = null;
    }
}

