/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Properties;
import java.util.TreeMap;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.management.internal.cli.commands.Product;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.ReflectionBasedAutoSerializer;
import org.apache.geode.test.dunit.Host;
import org.apache.geode.test.dunit.VM;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class NestedQueryClassCastExceptionFailureDUnitTest {
    @Rule
    public ClusterStartupRule cluster = new ClusterStartupRule();

    @Test
    public void classCastExceptionShouldNotBeThrownWhileExecutionNestedQueries() {
        Host host = Host.getHost(0);
        VM server = host.getVM("10240.0.0", 0);
        server.invoke(() -> {
            Properties properties = new Properties();
            properties.put("serializable-object-filter", "org.apache.geode.management.internal.cli.commands.*");
            Cache cache = new CacheFactory(properties).setPdxSerializer((PdxSerializer)new ReflectionBasedAutoSerializer(new String[]{"org.apache.geode.management.internal.cli.commands.*"})).create();
            CacheServer cacheServer = cache.addCacheServer();
            cacheServer.setPort(0);
            cacheServer.start();
            Region region = cache.createRegionFactory(RegionShortcut.REPLICATE).create("product");
            QueryService queryService = cache.getQueryService();
            queryService.createKeyIndex("productIDPKIndex", "productID", "/product");
            queryService.createIndex("productIdIndex", "productId", "/product");
            queryService.createIndex("productCodesGMIIndex", "productCodes['GMI']", "/product");
            TreeMap<String, String> tempMap = new TreeMap<String, String>();
            tempMap.put("GMI", "GMI");
            region.put((Object)1, (Object)new Product(1L, tempMap, "2L", "ACTIVE"));
            region.put((Object)2, (Object)new Product(2L, tempMap, null, "ACTIVE"));
            region.put((Object)3, (Object)new Product(3L, tempMap, "2L", "ACTIVE"));
            region.put((Object)4, (Object)new Product(4L, tempMap, null, "ACTIVE"));
            SelectResults results = (SelectResults)cache.getQueryService().newQuery("select  productId, productCodes['GMI'], contractSize from /product where contractSize = null and productCodes['GMI'] in (select  distinct b.productCodes['GMI'] from /product b where b.contractSize != null and b.status='ACTIVE') LIMIT 2000").execute();
            Assert.assertEquals((long)2L, (long)results.size());
        });
    }
}

