/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.Serializable;
import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.internal.AvailablePortHelper;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.internal.cli.dto.Value1;
import org.apache.geode.management.internal.cli.dto.Value2;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.test.dunit.Assert;
import org.apache.geode.test.dunit.SerializableRunnableIF;
import org.apache.geode.test.dunit.rules.ClusterStartupRule;
import org.apache.geode.test.dunit.rules.MemberVM;
import org.apache.geode.test.junit.rules.GfshCommandRule;
import org.assertj.core.api.Java6Assertions;
import org.junit.Rule;
import org.junit.Test;

public class GemfireDataCommandsDUnitTestBase {
    private static final String DATA_REGION_NAME = "GemfireDataCommandsTestRegion";
    private static final String DATA_REGION_NAME_VM1 = "GemfireDataCommandsTestRegion_Vm1";
    private static final String DATA_REGION_NAME_VM2 = "GemfireDataCommandsTestRegion_Vm2";
    private static final String DATA_REGION_NAME_PATH = "/GemfireDataCommandsTestRegion";
    private static final String DATA_REGION_NAME_VM1_PATH = "/GemfireDataCommandsTestRegion_Vm1";
    private static final String DATA_REGION_NAME_VM2_PATH = "/GemfireDataCommandsTestRegion_Vm2";
    private static final String DATA_PAR_REGION_NAME = "GemfireDataCommandsTestParRegion";
    private static final String DATA_PAR_REGION_NAME_VM1 = "GemfireDataCommandsTestParRegion_Vm1";
    private static final String DATA_PAR_REGION_NAME_VM2 = "GemfireDataCommandsTestParRegion_Vm2";
    private static final String DATA_PAR_REGION_NAME_PATH = "/GemfireDataCommandsTestParRegion";
    private static final String DATA_PAR_REGION_NAME_VM1_PATH = "/GemfireDataCommandsTestParRegion_Vm1";
    private static final String DATA_PAR_REGION_NAME_VM2_PATH = "/GemfireDataCommandsTestParRegion_Vm2";
    private static final String DATA_REGION_NAME_CHILD_1 = "ChildRegionRegion1";
    private static final String DATA_REGION_NAME_CHILD_1_2 = "ChildRegionRegion12";
    private static final String SERIALIZATION_FILTER = "org.apache.geode.management.internal.cli.**";
    @Rule
    public GfshCommandRule gfsh = new GfshCommandRule();
    @Rule
    public ClusterStartupRule cluster = new ClusterStartupRule();
    protected MemberVM locator;
    protected MemberVM server1;
    protected MemberVM server2;

    public void before() throws Exception {
        this.locator = this.cluster.startLocatorVM(0, this.locatorProperties(), new int[0]);
        this.server1 = this.cluster.startServerVM(1, this.locator.getPort());
        this.server2 = this.cluster.startServerVM(2, this.locator.getPort());
        this.connectToLocator();
    }

    public void connectToLocator() throws Exception {
        this.gfsh.connectAndVerify(this.locator, new String[0]);
    }

    private static void setupRegions(String regionName, String parRegionName) {
        InternalCache cache = ClusterStartupRule.getCache();
        RegionFactory regionFactory = cache.createRegionFactory(RegionShortcut.REPLICATE);
        Region dataRegion = regionFactory.create(DATA_REGION_NAME);
        Assert.assertNotNull((Object)dataRegion);
        dataRegion = dataRegion.createSubregion(DATA_REGION_NAME_CHILD_1, dataRegion.getAttributes());
        Assert.assertNotNull((Object)dataRegion);
        dataRegion = dataRegion.createSubregion(DATA_REGION_NAME_CHILD_1_2, dataRegion.getAttributes());
        Assert.assertNotNull((Object)dataRegion);
        dataRegion = regionFactory.create(regionName);
        Assert.assertNotNull((Object)dataRegion);
        PartitionAttributes partitionAttrs = new PartitionAttributesFactory().setRedundantCopies(2).create();
        RegionFactory partitionRegionFactory = cache.createRegionFactory(RegionShortcut.PARTITION);
        partitionRegionFactory.setPartitionAttributes(partitionAttrs);
        Region dataParRegion = partitionRegionFactory.create(DATA_PAR_REGION_NAME);
        Assert.assertNotNull((Object)dataParRegion);
        dataParRegion = partitionRegionFactory.create(parRegionName);
        Assert.assertNotNull((Object)dataParRegion);
    }

    void setupForGetPutRemoveLocateEntry(String testName) throws Exception {
        Properties props = this.locatorProperties();
        props.setProperty("serializable-object-filter", SERIALIZATION_FILTER);
        props.setProperty("name", testName + "Manager");
        Properties serverProps = new Properties();
        serverProps.setProperty("serializable-object-filter", SERIALIZATION_FILTER);
        this.locator = this.cluster.startLocatorVM(0, props, new int[0]);
        this.server1 = this.cluster.startServerVM(1, serverProps, this.locator.getPort());
        this.server2 = this.cluster.startServerVM(2, serverProps, this.locator.getPort());
        this.gfsh.connectAndVerify(this.locator, new String[0]);
        this.server1.invoke(() -> GemfireDataCommandsDUnitTestBase.setupRegions(DATA_REGION_NAME_VM1, DATA_PAR_REGION_NAME_VM1));
        this.server2.invoke(() -> GemfireDataCommandsDUnitTestBase.setupRegions(DATA_REGION_NAME_VM2, DATA_PAR_REGION_NAME_VM2));
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_PATH, 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_PATH, 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_VM1_PATH, 1);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_REGION_NAME_VM2_PATH, 1);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_PAR_REGION_NAME_PATH, 2);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_PAR_REGION_NAME_VM1_PATH, 1);
        this.locator.waitUntilRegionIsReadyOnExactlyThisManyServers(DATA_PAR_REGION_NAME_VM2_PATH, 1);
        this.locator.invoke(() -> {
            String[] regions;
            InternalCache cache = ClusterStartupRule.getCache();
            ManagementService service = ManagementService.getManagementService((Cache)cache);
            Assert.assertNotNull((Object)service.getMemberMXBean());
            Assert.assertNotNull((Object)service.getManagerMXBean());
            DistributedRegionMXBean bean = service.getDistributedRegionMXBean(DATA_REGION_NAME_PATH);
            Assert.assertNotNull((Object)bean);
            for (String region : regions = new String[]{DATA_REGION_NAME_PATH, DATA_REGION_NAME_VM1_PATH, DATA_REGION_NAME_VM2_PATH, DATA_PAR_REGION_NAME_PATH, DATA_PAR_REGION_NAME_VM1_PATH, DATA_PAR_REGION_NAME_VM2_PATH}) {
                bean = service.getDistributedRegionMXBean(region);
                Assert.assertNotNull((Object)bean);
                if (bean.getMemberCount() >= 1) continue;
                Assert.fail((String)"Even after waiting mbean reports number of member hosting region /GemfireDataCommandsTestRegion_Vm1 is less than one");
            }
        });
    }

    @Test
    public void testPrimitivesWithDataCommands() throws Exception {
        this.setupForGetPutRemoveLocateEntry("testPrimitives");
        Byte byteKey = Byte.parseByte("41");
        Byte byteValue = Byte.parseByte("31");
        Short shortKey = Short.parseShort("123");
        Short shortValue = Short.parseShort("121");
        Integer integerKey = Integer.parseInt("123456");
        Integer integerValue = Integer.parseInt("12345678");
        Float floatKey = Float.valueOf("12432.2325");
        Float floatValue = Float.valueOf("111111.1111");
        Double doubleKey = Double.valueOf("12432.235425");
        Double doubleValue = Double.valueOf("111111.111111");
        this.testGetPutLocateEntryFromShellAndGemfire(byteKey, byteValue, Byte.class, true, true);
        this.testGetPutLocateEntryFromShellAndGemfire(shortKey, shortValue, Short.class, true, true);
        this.testGetPutLocateEntryFromShellAndGemfire(integerKey, integerValue, Integer.class, true, true);
        this.testGetPutLocateEntryFromShellAndGemfire(floatKey, floatValue, Float.class, true, true);
        this.testGetPutLocateEntryFromShellAndGemfire(doubleKey, doubleValue, Double.class, true, true);
    }

    private void testGetPutLocateEntryFromShellAndGemfire(Serializable key, Serializable value, Class klass, boolean addRegionPath, boolean expResult) {
        SerializableRunnableIF putTask = () -> {
            InternalCache cache = ClusterStartupRule.getCache();
            Region region = cache.getRegion(DATA_REGION_NAME_PATH);
            Assert.assertNotNull((Object)region);
            region.clear();
            region.put((Object)key, (Object)value);
        };
        SerializableRunnableIF getTask = () -> {
            InternalCache cache = ClusterStartupRule.getCache();
            Region region = cache.getRegion(DATA_REGION_NAME_PATH);
            Assert.assertNotNull((Object)region);
            Assert.assertEquals((Object)true, (Object)region.containsKey((Object)key));
            Assert.assertEquals((Object)value, (Object)region.get((Object)key));
        };
        SerializableRunnableIF removeTask = () -> {
            InternalCache cache = ClusterStartupRule.getCache();
            Region region = cache.getRegion(DATA_REGION_NAME_PATH);
            Assert.assertNotNull((Object)region);
            Assert.assertEquals((Object)true, (Object)region.containsKey((Object)key));
            region.remove((Object)key);
        };
        SerializableRunnableIF clearTask = () -> {
            InternalCache cache = ClusterStartupRule.getCache();
            Region region = cache.getRegion(DATA_REGION_NAME_PATH);
            Assert.assertNotNull((Object)region);
            region.clear();
        };
        String canonicalName = klass.getCanonicalName();
        String getCommand = "get --key=" + key + " --key-class=" + canonicalName + " --value-class=" + canonicalName;
        if (addRegionPath) {
            getCommand = getCommand + " --region=/GemfireDataCommandsTestRegion";
        }
        String locateEntryCommand = "locate entry --key=" + key + " --key-class=" + canonicalName + " --value-class=" + canonicalName;
        if (addRegionPath) {
            locateEntryCommand = locateEntryCommand + " --region=/GemfireDataCommandsTestRegion";
        }
        String removeCommand = "remove --key=" + key + " --key-class=" + canonicalName;
        if (addRegionPath) {
            removeCommand = removeCommand + " --region=/GemfireDataCommandsTestRegion";
        }
        String putCommand = "put --key=" + key + " --key-class=" + canonicalName + " --value=" + value + " --value-class=" + canonicalName;
        if (addRegionPath) {
            putCommand = putCommand + " --region=/GemfireDataCommandsTestRegion";
        }
        if (expResult) {
            CommandResult cmdResult = this.gfsh.executeCommand(putCommand);
            this.validateResult(cmdResult, true);
            this.server1.invoke(getTask);
            this.server1.invoke(removeTask);
            this.server1.invoke(clearTask);
            this.server1.invoke(putTask);
            cmdResult = this.gfsh.executeCommand(getCommand);
            this.validateResult(cmdResult, true);
            cmdResult = this.gfsh.executeCommand(locateEntryCommand);
            this.validateResult(cmdResult, true);
            this.server1.invoke(removeTask);
            this.server1.invoke(clearTask);
            cmdResult = this.gfsh.executeCommand(putCommand);
            this.validateResult(cmdResult, true);
            this.server1.invoke(getTask);
            cmdResult = this.gfsh.executeCommand(removeCommand);
            this.validateResult(cmdResult, true);
            cmdResult = this.gfsh.executeCommand(getCommand);
            this.validateResult(cmdResult, false);
            cmdResult = this.gfsh.executeCommand(locateEntryCommand);
            this.validateResult(cmdResult, false);
        } else {
            CommandResult cmdResult = this.gfsh.executeCommand(putCommand);
            this.validateResult(cmdResult, false);
            this.server1.invoke(clearTask);
            this.server1.invoke(putTask);
            cmdResult = this.gfsh.executeCommand(getCommand);
            this.validateResult(cmdResult, false);
            cmdResult = this.gfsh.executeCommand(locateEntryCommand);
            this.validateResult(cmdResult, false);
            this.server1.invoke(removeTask);
            this.server1.invoke(clearTask);
            cmdResult = this.gfsh.executeCommand(putCommand);
            this.validateResult(cmdResult, false);
        }
    }

    private void validateResult(CommandResult cmdResult, Boolean expected) {
        ResultModel rd = cmdResult.getResultData();
        DataResultModel result = rd.getDataSection("data-info");
        Java6Assertions.assertThat((String)((String)result.getContent().get("Result"))).isEqualTo(expected.toString());
    }

    private Properties locatorProperties() {
        int jmxPort = AvailablePortHelper.getRandomAvailableTCPPort();
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("log-level", "fine");
        props.setProperty("jmx-manager-hostname-for-clients", "localhost");
        props.setProperty("jmx-manager-port", "" + jmxPort);
        return props;
    }

    public static class Value1WithValue2
    extends Value1 {
        private Value2 value2 = null;

        public Value1WithValue2(int i) {
            super(i);
            this.value2 = new Value2(i);
        }

        public Value2 getValue2() {
            return this.value2;
        }

        public void setValue2(Value2 value2) {
            this.value2 = value2;
        }
    }
}

