/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security.templates;

import java.security.Principal;
import java.util.Properties;
import org.apache.geode.LogWriter;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.Authenticator;
import org.apache.geode.security.templates.UsernamePrincipal;

public class DummyAuthenticator
implements Authenticator {
    public static Authenticator create() {
        return new DummyAuthenticator();
    }

    public static boolean checkValidName(String userName) {
        return userName.startsWith("user") || userName.startsWith("reader") || userName.startsWith("writer") || userName.equals("admin") || userName.equals("root") || userName.equals("administrator");
    }

    public void init(Properties securityProperties, LogWriter systemLogWriter, LogWriter securityLogWriter) throws AuthenticationFailedException {
    }

    public Principal authenticate(Properties credentials, DistributedMember member) throws AuthenticationFailedException {
        String userName = credentials.getProperty("security-username");
        if (userName == null) {
            throw new AuthenticationFailedException("DummyAuthenticator: user name property [security-username] not provided");
        }
        String password = credentials.getProperty("security-password");
        if (password == null) {
            throw new AuthenticationFailedException("DummyAuthenticator: password property [security-password] not provided");
        }
        if (userName.equals(password) && DummyAuthenticator.checkValidName(userName)) {
            return new UsernamePrincipal(userName);
        }
        throw new AuthenticationFailedException("DummyAuthenticator: Invalid user name [" + userName + "], password supplied.");
    }

    public void close() {
    }
}

