/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal.ops;

import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.security.NotAuthorizedException;
import org.jetbrains.annotations.NotNull;

public class CreateCQOp {
    public static Object execute(@NotNull ExecutablePool pool, @NotNull String cqName, @NotNull String queryStr, int cqState, boolean isDurable, @NotNull DataPolicy regionDataPolicy) {
        CreateCQOpImpl op = new CreateCQOpImpl(cqName, queryStr, cqState, isDurable, regionDataPolicy);
        return pool.executeOnQueuesAndReturnPrimaryResult((Op)op);
    }

    public static Object executeOn(@NotNull ExecutablePool pool, @NotNull Connection conn, @NotNull String cqName, @NotNull String queryStr, int cqState, boolean isDurable, @NotNull DataPolicy regionDataPolicy) {
        CreateCQOpImpl op = new CreateCQOpImpl(cqName, queryStr, cqState, isDurable, regionDataPolicy);
        return pool.executeOn(conn, (Op)op);
    }

    private CreateCQOp() {
    }

    protected static class CreateCQOpImpl
    extends AbstractOp {
        public CreateCQOpImpl(@NotNull String cqName, @NotNull String queryStr, int cqState, boolean isDurable, @NotNull DataPolicy regionDataPolicy) {
            super(MessageType.EXECUTECQ, 5);
            this.getMessage().addStringPart(cqName);
            this.getMessage().addStringPart(queryStr);
            this.getMessage().addIntPart(cqState);
            byte durableByte = (byte)(isDurable ? 1 : 0);
            this.getMessage().addBytesPart(new byte[]{durableByte});
            this.getMessage().addBytesPart(new byte[]{(byte)regionDataPolicy.ordinal()});
        }

        @NotNull
        protected Message createResponseMessage() {
            return new ChunkedMessage(1, KnownVersion.CURRENT);
        }

        protected Object processResponse(@NotNull Message m) throws Exception {
            ChunkedMessage msg = (ChunkedMessage)m;
            msg.readHeader();
            MessageType msgType = msg.getMessageType();
            msg.receiveChunk();
            if (msgType == MessageType.REPLY) {
                return Boolean.TRUE;
            }
            if (msgType == MessageType.EXCEPTION) {
                Part part = msg.getPart(0);
                String s = "While performing a remote " + this.getOpName();
                throw new ServerOperationException(s, (Throwable)part.getObject());
            }
            if (this.isErrorResponse(msgType)) {
                Part part = msg.getPart(0);
                String errorMessage = part.getString();
                if (errorMessage.contains("Not authorized")) {
                    throw new NotAuthorizedException(errorMessage);
                }
                throw new ServerOperationException(errorMessage);
            }
            throw new InternalGemFireError("Unexpected message type " + String.valueOf(msgType));
        }

        protected CreateCQOpImpl(MessageType msgType, int numParts) {
            super(msgType, numParts);
        }

        protected String getOpName() {
            return "createCQ";
        }

        protected boolean isErrorResponse(MessageType msgType) {
            return msgType == MessageType.CQDATAERROR || msgType == MessageType.CQ_EXCEPTION_TYPE;
        }

        protected long startAttempt(ConnectionStats stats) {
            return stats.startCreateCQ();
        }

        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endCreateCQSend(start, this.hasFailed());
        }

        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endCreateCQ(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

