/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal.ops;

import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.query.cq.internal.ops.CreateCQOp;
import org.apache.geode.internal.cache.tier.MessageType;

public class CloseCQOp {
    public static void execute(ExecutablePool pool, String cqName) {
        CloseCQOpImpl op = new CloseCQOpImpl(cqName);
        pool.executeOnAllQueueServers((Op)op);
    }

    private CloseCQOp() {
    }

    private static class CloseCQOpImpl
    extends CreateCQOp.CreateCQOpImpl {
        public CloseCQOpImpl(String cqName) {
            super(MessageType.CLOSECQ, 1);
            this.getMessage().addStringPart(cqName);
        }

        @Override
        protected String getOpName() {
            return "closeCQ";
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startCloseCQ();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endCloseCQSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endCloseCQ(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

