/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.sequencedmultisetstate.linked;

import java.util.Objects;
import org.apache.flink.table.data.RowData;

class Node {
    final RowData row;
    private final long sqn;
    final Long prevSqn;
    final Long nextSqn;
    final Long nextSqnForRecord;
    final Long timestamp;

    Node(RowData row, long sqn, Long prevSqn, Long nextSqn, Long nextSqnForRecord, Long timestamp) {
        this.row = row;
        this.sqn = sqn;
        this.prevSqn = prevSqn;
        this.nextSqn = nextSqn;
        this.nextSqnForRecord = nextSqnForRecord;
        this.timestamp = timestamp;
    }

    public boolean isLastForRecord() {
        return this.nextSqnForRecord == null;
    }

    public boolean isLowestSqn() {
        return !this.hasPrev();
    }

    public boolean isHighestSqn() {
        return !this.hasNext();
    }

    public boolean hasPrev() {
        return this.prevSqn != null;
    }

    public boolean hasNext() {
        return this.nextSqn != null;
    }

    public Node withNextForRecord(Long nextSeqNoForRecord) {
        return new Node(this.row, this.sqn, this.prevSqn, this.nextSqn, nextSeqNoForRecord, this.timestamp);
    }

    public Node withNext(Long nextSeqNo) {
        return new Node(this.row, this.sqn, this.prevSqn, nextSeqNo, this.nextSqnForRecord, this.timestamp);
    }

    public Node withPrev(Long prevSeqNo) {
        return new Node(this.row, this.sqn, prevSeqNo, this.nextSqn, this.nextSqnForRecord, this.timestamp);
    }

    public Node withRow(RowData row, long timestamp) {
        return new Node(row, this.sqn, this.prevSqn, this.nextSqn, this.nextSqnForRecord, timestamp);
    }

    public RowData getRow() {
        return this.row;
    }

    public long getSqn() {
        return this.sqn;
    }

    public Long getPrevSqn() {
        return this.prevSqn;
    }

    public Long getNextSqn() {
        return this.nextSqn;
    }

    public Long getNextSqnForRecord() {
        return this.nextSqnForRecord;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Node)) {
            return false;
        }
        Node node = (Node)o;
        return this.sqn == node.sqn && Objects.equals(this.prevSqn, node.prevSqn) && Objects.equals(this.nextSqn, node.nextSqn) && Objects.equals(this.nextSqnForRecord, node.nextSqnForRecord);
    }

    public int hashCode() {
        return Objects.hash(this.sqn, this.prevSqn, this.nextSqn, this.nextSqnForRecord);
    }
}

