/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.UpdatableRowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.apache.flink.table.runtime.util.StreamRecordCollector;
import org.apache.flink.util.Preconditions;

@Internal
public class ConstraintEnforcer
extends TableStreamOperator<RowData>
implements OneInputStreamOperator<RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private final ExecutionConfigOptions.NotNullEnforcer notNullEnforcer;
    private final int[] notNullFieldIndices;
    private final String[] allFieldNames;
    private final ExecutionConfigOptions.TypeLengthEnforcer typeLengthEnforcer;
    private final int[] charFieldIndices;
    private final int[] charFieldLengths;
    private final BitSet charFieldCouldPad;
    private final int[] binaryFieldIndices;
    private final int[] binaryFieldLengths;
    private final BitSet binaryFieldCouldPad;
    private final String operatorName;
    private transient StreamRecordCollector<RowData> collector;

    private ConstraintEnforcer(ExecutionConfigOptions.NotNullEnforcer notNullEnforcer, int[] notNullFieldIndices, ExecutionConfigOptions.TypeLengthEnforcer typeLengthEnforcer, int[] charFieldIndices, int[] charFieldLengths, BitSet charFieldCouldPad, int[] binaryFieldIndices, int[] binaryFieldLengths, BitSet binaryFieldCouldPad, String[] allFieldNames, String operatorName) {
        this.notNullEnforcer = notNullEnforcer;
        this.notNullFieldIndices = notNullFieldIndices;
        this.typeLengthEnforcer = typeLengthEnforcer;
        this.charFieldIndices = charFieldIndices;
        this.charFieldLengths = charFieldLengths;
        this.charFieldCouldPad = charFieldCouldPad;
        this.binaryFieldIndices = binaryFieldIndices;
        this.binaryFieldLengths = binaryFieldLengths;
        this.binaryFieldCouldPad = binaryFieldCouldPad;
        this.allFieldNames = allFieldNames;
        this.operatorName = operatorName;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.collector = new StreamRecordCollector(this.output);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static BitSet buildCouldPad(List<FieldInfo> charFieldInfo) {
        BitSet couldPad = new BitSet(charFieldInfo.size());
        for (int i = 0; i < charFieldInfo.size(); ++i) {
            if (!charFieldInfo.get((int)i).couldPad) continue;
            couldPad.set(i);
        }
        return couldPad;
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        RowData processedRowData = this.processNotNullConstraint((RowData)element.getValue());
        if (processedRowData != null) {
            processedRowData = this.processCharConstraint(processedRowData);
            processedRowData = this.processBinaryConstraint(processedRowData);
            this.collector.collect(processedRowData);
        }
    }

    @Nullable
    private RowData processNotNullConstraint(RowData rowData) {
        if (this.notNullEnforcer == null) {
            return rowData;
        }
        for (int index : this.notNullFieldIndices) {
            if (!rowData.isNullAt(index)) continue;
            switch (this.notNullEnforcer) {
                case ERROR: {
                    throw new TableException(String.format("Column '%s' is NOT NULL, however, a null value is being written into it. You can set job configuration '%s'='%s' to suppress this exception and drop such records silently.", this.allFieldNames[index], ExecutionConfigOptions.TABLE_EXEC_SINK_NOT_NULL_ENFORCER.key(), ExecutionConfigOptions.NotNullEnforcer.DROP.name()));
                }
                case DROP: {
                    return null;
                }
            }
        }
        return rowData;
    }

    private RowData processCharConstraint(RowData rowData) {
        if (this.typeLengthEnforcer == null || this.typeLengthEnforcer == ExecutionConfigOptions.TypeLengthEnforcer.IGNORE || this.charFieldIndices == null) {
            return rowData;
        }
        RowData updatedRowData = null;
        for (int i = 0; i < this.charFieldIndices.length; ++i) {
            int fieldIdx = this.charFieldIndices[i];
            int length = this.charFieldLengths[i];
            BinaryStringData stringData = (BinaryStringData)rowData.getString(fieldIdx);
            int sourceStrLength = stringData.numChars();
            if (this.charFieldCouldPad.get(i) && sourceStrLength < length) {
                if (updatedRowData == null) {
                    updatedRowData = new UpdatableRowData(rowData, this.allFieldNames.length);
                }
                int srcSizeInBytes = stringData.getSizeInBytes();
                byte[] newString = new byte[srcSizeInBytes + length - sourceStrLength];
                for (int j = srcSizeInBytes; j < newString.length; ++j) {
                    newString[j] = 32;
                }
                SegmentsUtil.copyToBytes(stringData.getSegments(), 0, newString, 0, srcSizeInBytes);
                updatedRowData.setField(fieldIdx, StringData.fromBytes((byte[])newString));
                continue;
            }
            if (sourceStrLength <= length) continue;
            if (updatedRowData == null) {
                updatedRowData = new UpdatableRowData(rowData, this.allFieldNames.length);
            }
            updatedRowData.setField(fieldIdx, stringData.substring(0, length));
        }
        return updatedRowData != null ? updatedRowData : rowData;
    }

    private RowData processBinaryConstraint(RowData rowData) {
        if (this.typeLengthEnforcer == null || this.typeLengthEnforcer == ExecutionConfigOptions.TypeLengthEnforcer.IGNORE || this.binaryFieldIndices == null) {
            return rowData;
        }
        RowData updatedRowData = null;
        for (int i = 0; i < this.binaryFieldLengths.length; ++i) {
            int fieldIdx = this.binaryFieldIndices[i];
            int length = this.binaryFieldLengths[i];
            byte[] binaryData = rowData.getBinary(fieldIdx);
            int sourceLength = binaryData.length;
            if (sourceLength <= length && (!this.binaryFieldCouldPad.get(i) || sourceLength >= length)) continue;
            if (updatedRowData == null) {
                updatedRowData = new UpdatableRowData(rowData, this.allFieldNames.length);
            }
            updatedRowData.setField(fieldIdx, Arrays.copyOf(binaryData, length));
        }
        return updatedRowData != null ? updatedRowData : rowData;
    }

    @Internal
    public static class FieldInfo {
        private final int fieldIdx;
        private final Integer length;
        private final boolean couldPad;

        public FieldInfo(int fieldIdx, @Nullable Integer length, boolean couldPad) {
            this.fieldIdx = fieldIdx;
            this.length = length;
            this.couldPad = couldPad;
        }

        public int fieldIdx() {
            return this.fieldIdx;
        }
    }

    public static class Builder {
        private ExecutionConfigOptions.NotNullEnforcer notNullEnforcer;
        private int[] notNullFieldIndices;
        private ExecutionConfigOptions.TypeLengthEnforcer typeLengthEnforcer;
        private List<FieldInfo> charFieldInfo;
        private List<FieldInfo> binaryFieldInfo;
        private String[] allFieldNames;
        private final List<String> operatorNames = new ArrayList<String>();
        private boolean isConfigured = false;

        public void addNotNullConstraint(ExecutionConfigOptions.NotNullEnforcer notNullEnforcer, int[] notNullFieldIndices, List<String> notNullFieldNames, String[] allFieldNames) {
            Preconditions.checkArgument((notNullFieldIndices.length > 0 ? 1 : 0) != 0, (Object)"ConstraintValidator requires that there are not-null fields.");
            this.notNullFieldIndices = notNullFieldIndices;
            this.notNullEnforcer = notNullEnforcer;
            this.allFieldNames = allFieldNames;
            if (notNullEnforcer != null) {
                this.operatorNames.add(String.format("NotNullEnforcer(fields=[%s])", String.join((CharSequence)", ", notNullFieldNames)));
                this.isConfigured = true;
            }
        }

        public void addCharLengthConstraint(ExecutionConfigOptions.TypeLengthEnforcer typeLengthEnforcer, List<FieldInfo> charFieldInfo, List<String> charFieldNames, String[] allFieldNames) {
            this.typeLengthEnforcer = typeLengthEnforcer;
            if (this.typeLengthEnforcer == ExecutionConfigOptions.TypeLengthEnforcer.TRIM_PAD) {
                Preconditions.checkArgument((charFieldInfo.size() > 0 ? 1 : 0) != 0, (Object)"ConstraintValidator requires that there are CHAR/VARCHAR fields.");
                this.charFieldInfo = charFieldInfo;
                this.allFieldNames = allFieldNames;
                this.operatorNames.add(String.format("LengthEnforcer(fields=[%s])", String.join((CharSequence)", ", charFieldNames)));
                this.isConfigured = true;
            }
        }

        public void addBinaryLengthConstraint(ExecutionConfigOptions.TypeLengthEnforcer typeLengthEnforcer, List<FieldInfo> binaryFieldInfo, List<String> binaryFieldNames, String[] allFieldNames) {
            this.typeLengthEnforcer = typeLengthEnforcer;
            if (this.typeLengthEnforcer == ExecutionConfigOptions.TypeLengthEnforcer.TRIM_PAD) {
                Preconditions.checkArgument((binaryFieldInfo.size() > 0 ? 1 : 0) != 0, (Object)"ConstraintValidator requires that there are BINARY/VARBINARY fields.");
                this.binaryFieldInfo = binaryFieldInfo;
                this.allFieldNames = allFieldNames;
                this.operatorNames.add(String.format("LengthEnforcer(fields=[%s])", String.join((CharSequence)", ", binaryFieldNames)));
                this.isConfigured = true;
            }
        }

        public ConstraintEnforcer build() {
            if (this.isConfigured) {
                String operatorName = "ConstraintEnforcer[" + String.join((CharSequence)", ", this.operatorNames) + "]";
                return new ConstraintEnforcer(this.notNullEnforcer, this.notNullFieldIndices, this.typeLengthEnforcer, this.charFieldInfo != null ? this.charFieldInfo.stream().mapToInt(fi -> fi.fieldIdx).toArray() : null, this.charFieldInfo != null ? this.charFieldInfo.stream().mapToInt(fi -> fi.length).toArray() : null, this.charFieldInfo != null ? ConstraintEnforcer.buildCouldPad(this.charFieldInfo) : null, this.binaryFieldInfo != null ? this.binaryFieldInfo.stream().mapToInt(fi -> fi.fieldIdx).toArray() : null, this.binaryFieldInfo != null ? this.binaryFieldInfo.stream().mapToInt(fi -> fi.length).toArray() : null, this.binaryFieldInfo != null ? ConstraintEnforcer.buildCouldPad(this.binaryFieldInfo) : null, this.allFieldNames, operatorName);
            }
            return null;
        }
    }
}

