/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream;

import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.stream.AbstractStreamingJoinOperator;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinRecordStateView;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinRecordStateViews;
import org.apache.flink.table.runtime.operators.join.stream.state.OuterJoinRecordStateView;
import org.apache.flink.table.runtime.operators.join.stream.state.OuterJoinRecordStateViews;
import org.apache.flink.table.runtime.operators.join.stream.utils.AssociatedRecords;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinHelper;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinInputSideSpec;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.types.RowKind;

public class StreamingJoinOperator
extends AbstractStreamingJoinOperator {
    private static final long serialVersionUID = -376944622236540545L;
    protected final boolean leftIsOuter;
    protected final boolean rightIsOuter;
    private transient JoinedRowData outRow;
    private transient RowData leftNullRow;
    private transient RowData rightNullRow;
    protected transient JoinRecordStateView leftRecordStateView;
    protected transient JoinRecordStateView rightRecordStateView;
    private transient SyncStateJoinHelper joinHelper;

    public StreamingJoinOperator(InternalTypeInfo<RowData> leftType, InternalTypeInfo<RowData> rightType, GeneratedJoinCondition generatedJoinCondition, JoinInputSideSpec leftInputSideSpec, JoinInputSideSpec rightInputSideSpec, boolean leftIsOuter, boolean rightIsOuter, boolean[] filterNullKeys, long leftStateRetentionTime, long rightStateRetentionTime) {
        super(leftType, rightType, generatedJoinCondition, leftInputSideSpec, rightInputSideSpec, filterNullKeys, leftStateRetentionTime, rightStateRetentionTime);
        this.leftIsOuter = leftIsOuter;
        this.rightIsOuter = rightIsOuter;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.outRow = new JoinedRowData();
        this.leftNullRow = new GenericRowData(this.leftType.toRowSize());
        this.rightNullRow = new GenericRowData(this.rightType.toRowSize());
        this.leftRecordStateView = this.leftIsOuter ? OuterJoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "left-records", this.leftInputSideSpec, this.leftType, this.leftStateRetentionTime) : JoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "left-records", this.leftInputSideSpec, this.leftType, this.leftStateRetentionTime);
        this.rightRecordStateView = this.rightIsOuter ? OuterJoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "right-records", this.rightInputSideSpec, this.rightType, this.rightStateRetentionTime) : JoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "right-records", this.rightInputSideSpec, this.rightType, this.rightStateRetentionTime);
        this.joinHelper = new SyncStateJoinHelper();
    }

    public void processElement1(StreamRecord<RowData> element) throws Exception {
        this.processElement((RowData)element.getValue(), this.leftRecordStateView, this.rightRecordStateView, true, false);
    }

    public void processElement2(StreamRecord<RowData> element) throws Exception {
        this.processElement((RowData)element.getValue(), this.rightRecordStateView, this.leftRecordStateView, false, false);
    }

    protected void processElement(RowData input, JoinRecordStateView inputSideStateView, JoinRecordStateView otherSideStateView, boolean inputIsLeft, boolean isSuppress) throws Exception {
        RowKind originalRowKind = input.getRowKind();
        input.setRowKind(RowKind.INSERT);
        AssociatedRecords associatedRecords = AssociatedRecords.fromSyncStateView(input, inputIsLeft, otherSideStateView, this.joinCondition);
        input.setRowKind(originalRowKind);
        this.joinHelper.processJoin(input, inputSideStateView, otherSideStateView, inputIsLeft, associatedRecords, isSuppress);
    }

    private class SyncStateJoinHelper
    extends JoinHelper<JoinRecordStateView, OuterJoinRecordStateView> {
        public SyncStateJoinHelper() {
            super(StreamingJoinOperator.this.leftIsOuter, StreamingJoinOperator.this.rightIsOuter, StreamingJoinOperator.this.outRow, StreamingJoinOperator.this.leftNullRow, StreamingJoinOperator.this.rightNullRow, (TimestampedCollector<RowData>)StreamingJoinOperator.this.collector);
        }

        @Override
        public void addRecord(JoinRecordStateView stateView, RowData record) throws Exception {
            stateView.addRecord(record);
        }

        @Override
        public void retractRecord(JoinRecordStateView stateView, RowData record) throws Exception {
            stateView.retractRecord(record);
        }

        @Override
        public void addRecordInOuterSide(OuterJoinRecordStateView stateView, RowData record, int numOfAssociations) throws Exception {
            stateView.addRecord(record, numOfAssociations);
        }

        @Override
        public void updateNumOfAssociationsInOuterSide(OuterJoinRecordStateView stateView, RowData record, int numOfAssociations) throws Exception {
            stateView.updateNumOfAssociations(record, numOfAssociations);
        }
    }
}

