/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggregate;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.runtime.functions.aggregate.BuiltInAggregateFunction;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.LinkedListSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public final class ArrayAggFunction<T>
extends BuiltInAggregateFunction<ArrayData, ArrayAggAccumulator<T>> {
    private static final long serialVersionUID = -5860934997657147836L;
    private final transient DataType elementDataType;
    private final boolean ignoreNulls;

    public ArrayAggFunction(LogicalType elementType, boolean ignoreNulls) {
        this.elementDataType = DataTypeUtils.toInternalDataType((LogicalType)elementType);
        this.ignoreNulls = ignoreNulls;
    }

    @Override
    public List<DataType> getArgumentDataTypes() {
        return Collections.singletonList(this.elementDataType);
    }

    @Override
    public DataType getAccumulatorDataType() {
        DataType linkedListType = this.getLinkedListType();
        return DataTypes.STRUCTURED(ArrayAggAccumulator.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"list", (DataType)linkedListType), DataTypes.FIELD((String)"retractList", (DataType)linkedListType)});
    }

    @Override
    public DataType getOutputDataType() {
        return (DataType)DataTypes.ARRAY((DataType)this.elementDataType).bridgedTo(ArrayData.class);
    }

    private DataType getLinkedListType() {
        TypeSerializer serializer = InternalSerializers.create(this.elementDataType.getLogicalType());
        return DataTypes.RAW(LinkedList.class, new LinkedListSerializer(serializer));
    }

    public ArrayAggAccumulator<T> createAccumulator() {
        ArrayAggAccumulator acc = new ArrayAggAccumulator();
        acc.list = new LinkedList();
        acc.retractList = new LinkedList();
        return acc;
    }

    public void accumulate(ArrayAggAccumulator<T> acc, T value) throws Exception {
        if (value != null || !this.ignoreNulls) {
            acc.list.add(value);
        }
    }

    public void retract(ArrayAggAccumulator<T> acc, T value) throws Exception {
        if (!(value == null && this.ignoreNulls || acc.list.remove(value))) {
            acc.retractList.add(value);
        }
    }

    public void merge(ArrayAggAccumulator<T> acc, Iterable<ArrayAggAccumulator<T>> its) throws Exception {
        LinkedList<ArrayAggAccumulator<Object>> newRetractBuffer = new LinkedList<ArrayAggAccumulator<Object>>();
        for (ArrayAggAccumulator<T> otherAcc : its) {
            if (!otherAcc.list.iterator().hasNext() && !otherAcc.retractList.iterator().hasNext()) continue;
            acc.list.addAll(otherAcc.list);
            acc.retractList.addAll(otherAcc.retractList);
        }
        for (ArrayAggAccumulator<Object> element : acc.retractList) {
            if (acc.list.remove(element)) continue;
            newRetractBuffer.add(element);
        }
        acc.retractList.clear();
        acc.retractList.addAll(newRetractBuffer);
    }

    public ArrayData getValue(ArrayAggAccumulator<T> acc) {
        try {
            LinkedList accList = acc.list;
            if (accList == null || accList.isEmpty()) {
                return null;
            }
            return new GenericArrayData(accList.toArray());
        }
        catch (Exception e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public void resetAccumulator(ArrayAggAccumulator<T> acc) {
        acc.list.clear();
        acc.retractList.clear();
    }

    public static class ArrayAggAccumulator<T> {
        public LinkedList<T> list;
        public LinkedList<T> retractList;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayAggAccumulator that = (ArrayAggAccumulator)o;
            return Objects.equals(this.list, that.list) && Objects.equals(this.retractList, that.retractList);
        }

        public int hashCode() {
            return Objects.hash(this.list, this.retractList);
        }
    }
}

