/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import java.io.Closeable;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

public class SpillChannelManager
implements Closeable {
    private final HashSet<FileIOChannel.ID> channels = CollectionUtil.newHashSetWithExpectedSize((int)64);
    private final HashSet<FileIOChannel> openChannels = CollectionUtil.newHashSetWithExpectedSize((int)64);
    private volatile boolean closed;

    public synchronized void addChannel(FileIOChannel.ID id) {
        Preconditions.checkArgument((!this.closed ? 1 : 0) != 0);
        this.channels.add(id);
    }

    public synchronized void addOpenChannels(List<FileIOChannel> toOpen) {
        Preconditions.checkArgument((!this.closed ? 1 : 0) != 0);
        for (FileIOChannel channel : toOpen) {
            this.openChannels.add(channel);
            this.channels.remove(channel.getChannelID());
        }
    }

    public synchronized void removeChannel(FileIOChannel.ID id) {
        Preconditions.checkArgument((!this.closed ? 1 : 0) != 0);
        this.channels.remove(id);
    }

    @Override
    public synchronized void close() {
        FileIOChannel channel;
        if (this.closed) {
            return;
        }
        this.closed = true;
        Iterator<FileIOChannel> channels = this.openChannels.iterator();
        while (channels.hasNext()) {
            channel = channels.next();
            channels.remove();
            try {
                channel.closeAndDelete();
            }
            catch (Throwable throwable) {}
        }
        channels = this.channels.iterator();
        while (channels.hasNext()) {
            channel = (FileIOChannel.ID)channels.next();
            channels.remove();
            try {
                File f = new File(channel.getPath());
                if (!f.exists()) continue;
                f.delete();
            }
            catch (Throwable throwable) {}
        }
    }
}

