/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.table.lookup.fullcache;

import java.util.Collection;
import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.ThreadSafeSimpleCounter;
import org.apache.flink.metrics.groups.CacheMetricGroup;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.connector.source.lookup.cache.trigger.CacheReloadTrigger;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.functions.table.lookup.fullcache.CacheLoader;
import org.apache.flink.table.runtime.functions.table.lookup.fullcache.ReloadTriggerContext;
import org.apache.flink.util.Preconditions;

@Internal
public class LookupFullCache
implements LookupCache {
    private static final long serialVersionUID = 1L;
    private final CacheLoader cacheLoader;
    private final CacheReloadTrigger reloadTrigger;
    private volatile transient ReloadTriggerContext reloadTriggerContext;
    private volatile transient Throwable reloadFailCause;
    private transient Counter hitCounter;
    private transient ClassLoader userCodeClassLoader;

    public LookupFullCache(CacheLoader cacheLoader, CacheReloadTrigger reloadTrigger) {
        this.cacheLoader = (CacheLoader)Preconditions.checkNotNull((Object)cacheLoader);
        this.reloadTrigger = (CacheReloadTrigger)Preconditions.checkNotNull((Object)reloadTrigger);
    }

    public void setUserCodeClassLoader(ClassLoader userCodeClassLoader) {
        this.userCodeClassLoader = userCodeClassLoader;
    }

    public synchronized void open(CacheMetricGroup metricGroup) {
        if (this.hitCounter == null) {
            this.hitCounter = new ThreadSafeSimpleCounter();
        }
        metricGroup.hitCounter(this.hitCounter);
        metricGroup.missCounter((Counter)new SimpleCounter());
        this.cacheLoader.initializeMetrics(metricGroup);
        if (this.reloadTriggerContext == null) {
            try {
                Preconditions.checkNotNull((Object)this.userCodeClassLoader, (String)"User code classloader must be initialized before opening full cache");
                this.cacheLoader.open(new Configuration(), this.userCodeClassLoader);
                this.reloadTriggerContext = new ReloadTriggerContext(this.cacheLoader::reloadAsync, th -> {
                    if (this.reloadFailCause == null) {
                        this.reloadFailCause = th;
                    } else {
                        this.reloadFailCause.addSuppressed((Throwable)th);
                    }
                });
                this.reloadTrigger.open((CacheReloadTrigger.Context)this.reloadTriggerContext);
                this.cacheLoader.awaitFirstLoad();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open lookup 'FULL' cache.", e);
            }
        }
    }

    public Collection<RowData> getIfPresent(RowData key) {
        if (this.reloadFailCause != null) {
            throw new RuntimeException(this.reloadFailCause);
        }
        Collection result = this.cacheLoader.getCache().getOrDefault(key, Collections.emptyList());
        this.hitCounter.inc();
        return result;
    }

    public Collection<RowData> put(RowData key, Collection<RowData> value) {
        throw new UnsupportedOperationException("Lookup Full cache doesn't support public 'put' operation from the outside.");
    }

    public void invalidate(RowData key) {
        throw new UnsupportedOperationException("Lookup Full cache doesn't support public 'invalidate' operation from the outside.");
    }

    public long size() {
        return this.cacheLoader.getCache().size();
    }

    public void close() throws Exception {
        this.reloadTrigger.close();
        this.cacheLoader.close();
    }
}

