/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class MapFromArraysFunction
extends BuiltInScalarFunction {
    public MapFromArraysFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.MAP_FROM_ARRAYS, context);
    }

    @Nullable
    public MapData eval(@Nullable ArrayData keysArray, @Nullable ArrayData valuesArray) {
        if (keysArray == null || valuesArray == null) {
            return null;
        }
        if (keysArray.size() != valuesArray.size()) {
            throw new FlinkRuntimeException("Invalid function MAP_FROM_ARRAYS call:\nThe length of the keys array " + keysArray.size() + " is not equal to the length of the values array " + valuesArray.size());
        }
        return new MapDataForMapFromArrays(keysArray, valuesArray);
    }

    private static class MapDataForMapFromArrays
    implements MapData {
        private final ArrayData keyArray;
        private final ArrayData valueArray;

        public MapDataForMapFromArrays(ArrayData keyArray, ArrayData valueArray) {
            this.keyArray = keyArray;
            this.valueArray = valueArray;
        }

        public int size() {
            return this.keyArray.size();
        }

        public ArrayData keyArray() {
            return this.keyArray;
        }

        public ArrayData valueArray() {
            return this.valueArray;
        }
    }
}

