/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.slicing;

import java.io.Serializable;
import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.slicing.ClockService;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.slicing.SliceSharedAssigner;
import org.apache.flink.table.runtime.operators.window.slicing.SliceUnsharedAssigner;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.util.IterableIterator;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;

@Internal
public final class SliceAssigners {
    public static TumblingSliceAssigner tumbling(int rowtimeIndex, ZoneId shiftTimeZone, Duration size) {
        return new TumblingSliceAssigner(rowtimeIndex, shiftTimeZone, size.toMillis(), 0L);
    }

    public static HoppingSliceAssigner hopping(int rowtimeIndex, ZoneId shiftTimeZone, Duration size, Duration slide) {
        return new HoppingSliceAssigner(rowtimeIndex, shiftTimeZone, size.toMillis(), slide.toMillis(), 0L);
    }

    public static CumulativeSliceAssigner cumulative(int rowtimeIndex, ZoneId shiftTimeZone, Duration maxSize, Duration step) {
        return new CumulativeSliceAssigner(rowtimeIndex, shiftTimeZone, maxSize.toMillis(), step.toMillis(), 0L);
    }

    public static WindowedSliceAssigner windowed(int windowEndIndex, SliceAssigner innerAssigner) {
        return new WindowedSliceAssigner(windowEndIndex, innerAssigner);
    }

    public static SliceAssigner sliced(int sliceEndIndex, SliceAssigner innerAssigner) {
        if (innerAssigner instanceof SliceSharedAssigner) {
            return new SlicedSharedSliceAssigner(sliceEndIndex, (SliceSharedAssigner)innerAssigner);
        }
        return new SlicedUnsharedSliceAssigner(sliceEndIndex, innerAssigner);
    }

    private SliceAssigners() {
    }

    private static final class HoppingSlicesIterable
    implements IterableIterator<Long>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final long sliceSize;
        private long lastSliceEnd;
        private int numSlicesRemaining;

        HoppingSlicesIterable(long lastSliceEnd, long sliceSize, int numSlicesPerWindow) {
            this.lastSliceEnd = lastSliceEnd;
            this.sliceSize = sliceSize;
            this.numSlicesRemaining = numSlicesPerWindow;
        }

        public boolean hasNext() {
            return this.numSlicesRemaining > 0;
        }

        public Long next() {
            long slice = this.lastSliceEnd;
            --this.numSlicesRemaining;
            this.lastSliceEnd -= this.sliceSize;
            return slice;
        }

        public Iterator<Long> iterator() {
            return this;
        }
    }

    private static final class ReusableListIterable
    implements IterableIterator<Long>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<Long> values = new ArrayList<Long>();
        private int index = 0;

        private ReusableListIterable() {
        }

        public void clear() {
            this.values.clear();
            this.index = 0;
        }

        public void reset(Long slice) {
            this.values.clear();
            this.values.add(slice);
            this.index = 0;
        }

        public void reset(Long slice1, Long slice2) {
            this.values.clear();
            this.values.add(slice1);
            this.values.add(slice2);
            this.index = 0;
        }

        public Iterator<Long> iterator() {
            this.index = 0;
            return this;
        }

        public boolean hasNext() {
            return this.index < this.values.size();
        }

        public Long next() {
            Long value = this.values.get(this.index);
            ++this.index;
            return value;
        }
    }

    private static abstract class AbstractSliceAssigner
    implements SliceAssigner {
        private static final long serialVersionUID = 1L;
        protected final int rowtimeIndex;
        protected final boolean isEventTime;
        protected final ZoneId shiftTimeZone;

        protected AbstractSliceAssigner(int rowtimeIndex, ZoneId shiftTimeZone) {
            this.rowtimeIndex = rowtimeIndex;
            this.shiftTimeZone = shiftTimeZone;
            this.isEventTime = rowtimeIndex >= 0;
        }

        public abstract long assignSliceEnd(long var1);

        @Override
        public final long assignSliceEnd(RowData element, ClockService clock) {
            long timestamp;
            if (this.rowtimeIndex >= 0) {
                if (element.isNullAt(this.rowtimeIndex)) {
                    throw new RuntimeException("RowTime field should not be null, please convert it to a non-null long value.");
                }
                TimestampData rowTime = element.getTimestamp(this.rowtimeIndex, 3);
                timestamp = TimeWindowUtil.toUtcTimestampMills(rowTime.getMillisecond(), this.shiftTimeZone);
            } else {
                timestamp = TimeWindowUtil.toUtcTimestampMills(clock.currentProcessingTime(), this.shiftTimeZone);
            }
            return this.assignSliceEnd(timestamp);
        }

        @Override
        public final boolean isEventTime() {
            return this.isEventTime;
        }
    }

    private static abstract class AbstractSlicedSliceAssigner
    implements SliceAssigner {
        private static final long serialVersionUID = 1L;
        private final int sliceEndIndex;
        protected final SliceAssigner innerAssigner;

        public AbstractSlicedSliceAssigner(int sliceEndIndex, SliceAssigner innerAssigner) {
            Preconditions.checkArgument((sliceEndIndex >= 0 ? 1 : 0) != 0, (Object)"Windowed slice assigner must have a positive window end index.");
            this.sliceEndIndex = sliceEndIndex;
            this.innerAssigner = innerAssigner;
        }

        @Override
        public long assignSliceEnd(RowData element, ClockService clock) {
            return element.getTimestamp(this.sliceEndIndex, 3).getMillisecond();
        }

        @Override
        public long getWindowStart(long windowEnd) {
            return this.innerAssigner.getWindowStart(windowEnd);
        }

        @Override
        public Iterable<Long> expiredSlices(long windowEnd) {
            return this.innerAssigner.expiredSlices(windowEnd);
        }

        @Override
        public long getSliceEndInterval() {
            return this.innerAssigner.getSliceEndInterval();
        }

        @Override
        public boolean isEventTime() {
            return true;
        }
    }

    public static final class SlicedUnsharedSliceAssigner
    extends AbstractSlicedSliceAssigner
    implements SliceUnsharedAssigner {
        private static final long serialVersionUID = 1L;

        public SlicedUnsharedSliceAssigner(int sliceEndIndex, SliceAssigner innerAssigner) {
            super(sliceEndIndex, innerAssigner);
        }

        @Override
        public long getLastWindowEnd(long sliceEnd) {
            return sliceEnd;
        }
    }

    public static final class SlicedSharedSliceAssigner
    extends AbstractSlicedSliceAssigner
    implements SliceSharedAssigner {
        private static final long serialVersionUID = 1L;
        private final SliceSharedAssigner innerSharedAssigner;

        public SlicedSharedSliceAssigner(int sliceEndIndex, SliceSharedAssigner innerAssigner) {
            super(sliceEndIndex, innerAssigner);
            this.innerSharedAssigner = innerAssigner;
        }

        @Override
        public void mergeSlices(long sliceEnd, SliceSharedAssigner.MergeCallback callback) throws Exception {
            this.innerSharedAssigner.mergeSlices(sliceEnd, callback);
        }

        @Override
        public Optional<Long> nextTriggerWindow(long windowEnd, Supplier<Boolean> isWindowEmpty) {
            return this.innerSharedAssigner.nextTriggerWindow(windowEnd, isWindowEmpty);
        }

        @Override
        public long getLastWindowEnd(long sliceEnd) {
            return this.innerAssigner.getLastWindowEnd(sliceEnd);
        }
    }

    public static final class WindowedSliceAssigner
    implements SliceUnsharedAssigner {
        private static final long serialVersionUID = 1L;
        private final int windowEndIndex;
        private final SliceAssigner innerAssigner;
        private final ReusableListIterable reuseExpiredList = new ReusableListIterable();

        public WindowedSliceAssigner(int windowEndIndex, SliceAssigner innerAssigner) {
            Preconditions.checkArgument((windowEndIndex >= 0 ? 1 : 0) != 0, (Object)"Windowed slice assigner must have a positive window end index.");
            this.windowEndIndex = windowEndIndex;
            this.innerAssigner = innerAssigner;
        }

        @Override
        public long assignSliceEnd(RowData element, ClockService clock) {
            return element.getTimestamp(this.windowEndIndex, 3).getMillisecond();
        }

        @Override
        public long getLastWindowEnd(long sliceEnd) {
            return sliceEnd;
        }

        @Override
        public long getWindowStart(long windowEnd) {
            return this.innerAssigner.getWindowStart(windowEnd);
        }

        @Override
        public Iterable<Long> expiredSlices(long windowEnd) {
            this.reuseExpiredList.reset(windowEnd);
            return this.reuseExpiredList;
        }

        @Override
        public long getSliceEndInterval() {
            return this.innerAssigner.getSliceEndInterval();
        }

        @Override
        public boolean isEventTime() {
            return true;
        }
    }

    public static final class CumulativeSliceAssigner
    extends AbstractSliceAssigner
    implements SliceSharedAssigner {
        private static final long serialVersionUID = 1L;
        private final long maxSize;
        private final long step;
        private final long offset;
        private final ReusableListIterable reuseToBeMergedList = new ReusableListIterable();
        private final ReusableListIterable reuseExpiredList = new ReusableListIterable();

        public CumulativeSliceAssigner withOffset(Duration offset) {
            return new CumulativeSliceAssigner(this.rowtimeIndex, this.shiftTimeZone, this.maxSize, this.step, offset.toMillis());
        }

        protected CumulativeSliceAssigner(int rowtimeIndex, ZoneId shiftTimeZone, long maxSize, long step, long offset) {
            super(rowtimeIndex, shiftTimeZone);
            if (maxSize <= 0L || step <= 0L) {
                throw new IllegalArgumentException(String.format("Cumulative Window parameters must satisfy maxSize > 0 and step > 0, but got maxSize %dms and step %dms.", maxSize, step));
            }
            if (maxSize % step != 0L) {
                throw new IllegalArgumentException(String.format("Cumulative Window requires maxSize must be an integral multiple of step, but got maxSize %dms and step %dms.", maxSize, step));
            }
            this.maxSize = maxSize;
            this.step = step;
            this.offset = offset;
        }

        @Override
        public long assignSliceEnd(long timestamp) {
            long start = TimeWindow.getWindowStartWithOffset(timestamp, this.offset, this.step);
            return start + this.step;
        }

        @Override
        public long getLastWindowEnd(long sliceEnd) {
            long windowStart = this.getWindowStart(sliceEnd);
            return windowStart + this.maxSize;
        }

        @Override
        public long getWindowStart(long windowEnd) {
            return TimeWindow.getWindowStartWithOffset(windowEnd - 1L, this.offset, this.maxSize);
        }

        @Override
        public Iterable<Long> expiredSlices(long windowEnd) {
            long windowStart = this.getWindowStart(windowEnd);
            long firstSliceEnd = windowStart + this.step;
            long lastSliceEnd = windowStart + this.maxSize;
            if (windowEnd == firstSliceEnd) {
                this.reuseExpiredList.clear();
            } else if (windowEnd == lastSliceEnd) {
                this.reuseExpiredList.reset(windowEnd, firstSliceEnd);
            } else {
                this.reuseExpiredList.reset(windowEnd);
            }
            return this.reuseExpiredList;
        }

        @Override
        public long getSliceEndInterval() {
            return this.step;
        }

        @Override
        public void mergeSlices(long sliceEnd, SliceSharedAssigner.MergeCallback callback) throws Exception {
            long windowStart = this.getWindowStart(sliceEnd);
            long firstSliceEnd = windowStart + this.step;
            if (sliceEnd == firstSliceEnd) {
                this.reuseToBeMergedList.clear();
            } else {
                this.reuseToBeMergedList.reset(sliceEnd);
            }
            callback.merge(firstSliceEnd, (Iterable<Long>)((Object)this.reuseToBeMergedList));
        }

        @Override
        public Optional<Long> nextTriggerWindow(long windowEnd, Supplier<Boolean> isWindowEmpty) {
            long nextWindowEnd = windowEnd + this.step;
            long maxWindowEnd = this.getWindowStart(windowEnd) + this.maxSize;
            if (nextWindowEnd > maxWindowEnd) {
                return Optional.empty();
            }
            return Optional.of(nextWindowEnd);
        }
    }

    public static final class HoppingSliceAssigner
    extends AbstractSliceAssigner
    implements SliceSharedAssigner {
        private static final long serialVersionUID = 1L;
        private final long size;
        private final long slide;
        private final long offset;
        private final long sliceSize;
        private final int numSlicesPerWindow;
        private final ReusableListIterable reuseExpiredList = new ReusableListIterable();

        public HoppingSliceAssigner withOffset(Duration offset) {
            return new HoppingSliceAssigner(this.rowtimeIndex, this.shiftTimeZone, this.size, this.slide, offset.toMillis());
        }

        protected HoppingSliceAssigner(int rowtimeIndex, ZoneId shiftTimeZone, long size, long slide, long offset) {
            super(rowtimeIndex, shiftTimeZone);
            if (size <= 0L || slide <= 0L) {
                throw new IllegalArgumentException(String.format("Hopping Window must satisfy slide > 0 and size > 0, but got slide %dms and size %dms.", slide, size));
            }
            if (size % slide != 0L) {
                throw new IllegalArgumentException(String.format("Slicing Hopping Window requires size must be an integral multiple of slide, but got size %dms and slide %dms.", size, slide));
            }
            this.size = size;
            this.slide = slide;
            this.offset = offset;
            this.sliceSize = ArithmeticUtils.gcd((long)size, (long)slide);
            this.numSlicesPerWindow = MathUtils.checkedDownCast((long)(size / this.sliceSize));
        }

        @Override
        public long assignSliceEnd(long timestamp) {
            long start = TimeWindow.getWindowStartWithOffset(timestamp, this.offset, this.sliceSize);
            return start + this.sliceSize;
        }

        @Override
        public long getLastWindowEnd(long sliceEnd) {
            return sliceEnd - this.sliceSize + this.size;
        }

        @Override
        public long getWindowStart(long windowEnd) {
            return windowEnd - this.size;
        }

        @Override
        public Iterable<Long> expiredSlices(long windowEnd) {
            long windowStart = this.getWindowStart(windowEnd);
            long firstSliceEnd = windowStart + this.sliceSize;
            this.reuseExpiredList.reset(firstSliceEnd);
            return this.reuseExpiredList;
        }

        @Override
        public long getSliceEndInterval() {
            return this.sliceSize;
        }

        @Override
        public void mergeSlices(long sliceEnd, SliceSharedAssigner.MergeCallback callback) throws Exception {
            HoppingSlicesIterable toBeMerged = new HoppingSlicesIterable(sliceEnd, this.sliceSize, this.numSlicesPerWindow);
            callback.merge(null, (Iterable<Long>)((Object)toBeMerged));
        }

        @Override
        public Optional<Long> nextTriggerWindow(long windowEnd, Supplier<Boolean> isWindowEmpty) {
            if (isWindowEmpty.get().booleanValue()) {
                return Optional.empty();
            }
            return Optional.of(windowEnd + this.sliceSize);
        }
    }

    public static final class TumblingSliceAssigner
    extends AbstractSliceAssigner
    implements SliceUnsharedAssigner {
        private static final long serialVersionUID = 1L;
        private final long size;
        private final long offset;
        private final ReusableListIterable reuseExpiredList = new ReusableListIterable();

        public TumblingSliceAssigner withOffset(Duration offset) {
            return new TumblingSliceAssigner(this.rowtimeIndex, this.shiftTimeZone, this.size, offset.toMillis());
        }

        private TumblingSliceAssigner(int rowtimeIndex, ZoneId shiftTimeZone, long size, long offset) {
            super(rowtimeIndex, shiftTimeZone);
            Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)String.format("Tumbling Window parameters must satisfy size > 0, but got size %dms.", size));
            Preconditions.checkArgument((Math.abs(offset) < size ? 1 : 0) != 0, (Object)String.format("Tumbling Window parameters must satisfy abs(offset) < size, bot got size %dms and offset %dms.", size, offset));
            this.size = size;
            this.offset = offset;
        }

        @Override
        public long assignSliceEnd(long timestamp) {
            long start = TimeWindow.getWindowStartWithOffset(timestamp, this.offset, this.size);
            return start + this.size;
        }

        @Override
        public long getLastWindowEnd(long sliceEnd) {
            return sliceEnd;
        }

        @Override
        public long getWindowStart(long windowEnd) {
            return windowEnd - this.size;
        }

        @Override
        public Iterable<Long> expiredSlices(long windowEnd) {
            this.reuseExpiredList.reset(windowEnd);
            return this.reuseExpiredList;
        }

        @Override
        public long getSliceEndInterval() {
            return this.size;
        }
    }
}

