/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.table.lookup;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.RefCounted;

@Internal
public class LookupCacheManager {
    private static LookupCacheManager instance;
    private static boolean keepCacheOnRelease;
    private final Map<String, RefCountedCache> managedCaches = new HashMap<String, RefCountedCache>();

    private LookupCacheManager() {
    }

    public static synchronized LookupCacheManager getInstance() {
        if (instance == null) {
            instance = new LookupCacheManager();
        }
        return instance;
    }

    public synchronized LookupCache registerCacheIfAbsent(String cacheIdentifier, LookupCache cache) {
        Preconditions.checkNotNull((Object)cache, (String)"Could not register null cache in the manager");
        RefCountedCache refCountedCache = this.managedCaches.computeIfAbsent(cacheIdentifier, identifier -> new RefCountedCache(cache));
        refCountedCache.retain();
        return refCountedCache.cache;
    }

    public synchronized void unregisterCache(String cacheIdentifier) {
        RefCountedCache refCountedCache = (RefCountedCache)Preconditions.checkNotNull((Object)this.managedCaches.get(cacheIdentifier), (String)"Cache identifier '%s' is not registered", (Object[])new Object[]{cacheIdentifier});
        if (refCountedCache.release()) {
            this.managedCaches.remove(cacheIdentifier);
        }
    }

    public static void keepCacheOnRelease(boolean toKeep) {
        keepCacheOnRelease = toKeep;
    }

    public void checkAllReleased() {
        if (this.managedCaches.isEmpty()) {
            return;
        }
        String leakedCaches = this.managedCaches.entrySet().stream().filter(entry -> ((RefCountedCache)entry.getValue()).refCount != 0).map(entry -> String.format("#Reference: %d with ID: %s", ((RefCountedCache)entry.getValue()).refCount, entry.getKey())).collect(Collectors.joining("\n"));
        if (!leakedCaches.isEmpty()) {
            throw new IllegalStateException("Cache leak detected. Unreleased caches: \n" + leakedCaches);
        }
    }

    public void clear() {
        this.managedCaches.forEach((identifier, cache) -> ((RefCountedCache)cache).closeCache());
        this.managedCaches.clear();
    }

    public Map<String, RefCountedCache> getManagedCaches() {
        return this.managedCaches;
    }

    static {
        keepCacheOnRelease = false;
    }

    @NotThreadSafe
    @VisibleForTesting
    public static class RefCountedCache
    implements RefCounted {
        private final LookupCache cache;
        private int refCount;

        public RefCountedCache(LookupCache cache) {
            this.cache = cache;
            this.refCount = 0;
        }

        public void retain() {
            ++this.refCount;
        }

        public boolean release() {
            Preconditions.checkState((this.refCount > 0 ? 1 : 0) != 0, (Object)"Could not release a cache with refCount = 0");
            if (--this.refCount == 0 && !keepCacheOnRelease) {
                this.closeCache();
                return true;
            }
            return false;
        }

        public LookupCache getCache() {
            return this.cache;
        }

        private void closeCache() {
            try {
                this.cache.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to close the cache", e);
            }
        }
    }
}

