/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class ModelDescriptor {
    @Nullable
    private final Schema inputSchema;
    @Nullable
    private final Schema outputSchema;
    private final Map<String, String> modelOptions;
    @Nullable
    private final String comment;

    protected ModelDescriptor(@Nullable Schema inputSchema, @Nullable Schema outputSchema, Map<String, String> modelOptions, @Nullable String comment) {
        this.inputSchema = inputSchema;
        this.outputSchema = outputSchema;
        this.modelOptions = modelOptions;
        this.comment = comment;
    }

    public CatalogModel toCatalogModel() {
        Schema inputSchema = this.getInputSchema().orElseThrow(() -> new ValidationException("Input schema missing in ModelDescriptor. Input schema cannot be null."));
        Schema outputSchema = this.getOutputSchema().orElseThrow(() -> new ValidationException("Output schema missing in ModelDescriptor. Output schema cannot be null."));
        return CatalogModel.of((Schema)inputSchema, (Schema)outputSchema, this.modelOptions, (String)this.comment);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    Map<String, String> getOptions() {
        return Map.copyOf(this.modelOptions);
    }

    Optional<Schema> getInputSchema() {
        return Optional.ofNullable(this.inputSchema);
    }

    Optional<Schema> getOutputSchema() {
        return Optional.ofNullable(this.outputSchema);
    }

    Optional<String> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public static Builder forProvider(String provider) {
        Preconditions.checkNotNull((Object)provider, (String)"Model descriptors require a provider value.");
        Builder descriptorBuilder = new Builder();
        descriptorBuilder.option(FactoryUtil.PROVIDER, provider);
        return descriptorBuilder;
    }

    public String toString() {
        String serializedOptions = this.modelOptions.entrySet().stream().map(entry -> String.format("  '%s' = '%s'", EncodingUtils.escapeSingleQuotes((String)((String)entry.getKey())), EncodingUtils.escapeSingleQuotes((String)((String)entry.getValue())))).collect(Collectors.joining(String.format(",%n", new Object[0])));
        return String.format("%s%n%s%nCOMMENT '%s'%nWITH (%n%s%n)", this.inputSchema != null ? this.inputSchema : "", this.outputSchema != null ? this.outputSchema : "", this.comment != null ? this.comment : "", serializedOptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelDescriptor that = (ModelDescriptor)o;
        return Objects.equals(this.inputSchema, that.inputSchema) && Objects.equals(this.outputSchema, that.outputSchema) && this.modelOptions.equals(that.modelOptions) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(this.inputSchema, this.outputSchema, this.modelOptions, this.comment);
    }

    @PublicEvolving
    public static class Builder {
        @Nullable
        private Schema inputSchema;
        @Nullable
        private Schema outputSchema;
        private final Map<String, String> modelOptions;
        @Nullable
        private String comment;

        private Builder() {
            this.modelOptions = new HashMap<String, String>();
        }

        private Builder(ModelDescriptor descriptor) {
            this.inputSchema = descriptor.getInputSchema().orElse(null);
            this.outputSchema = descriptor.getOutputSchema().orElse(null);
            this.modelOptions = new HashMap<String, String>(descriptor.getOptions());
            this.comment = descriptor.getComment().orElse(null);
        }

        public <T> Builder option(ConfigOption<T> configOption, T value) {
            Preconditions.checkNotNull(configOption, (String)"Config option must not be null.");
            Preconditions.checkNotNull(value, (String)"Value must not be null.");
            this.modelOptions.put(configOption.key(), (String)ConfigurationUtils.convertValue(value, String.class));
            return this;
        }

        public Builder option(String key, String value) {
            Preconditions.checkNotNull((Object)key, (String)"Key must not be null.");
            Preconditions.checkNotNull((Object)value, (String)"Value must not be null.");
            this.modelOptions.put(key, value);
            return this;
        }

        public Builder inputSchema(@Nullable Schema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public Builder outputSchema(@Nullable Schema outputSchema) {
            this.outputSchema = outputSchema;
            return this;
        }

        public Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public ModelDescriptor build() {
            return new ModelDescriptor(this.inputSchema, this.outputSchema, this.modelOptions, this.comment);
        }
    }
}

