/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.AggregatedTable;
import org.apache.flink.table.api.Executable;
import org.apache.flink.table.api.Explainable;
import org.apache.flink.table.api.FlatAggregateTable;
import org.apache.flink.table.api.GroupWindow;
import org.apache.flink.table.api.GroupWindowedTable;
import org.apache.flink.table.api.GroupedTable;
import org.apache.flink.table.api.OverWindow;
import org.apache.flink.table.api.OverWindowedTable;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TablePipeline;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.operations.QueryOperation;

@PublicEvolving
public interface Table
extends Explainable<Table>,
Executable {
    @Deprecated
    default public TableSchema getSchema() {
        return TableSchema.fromResolvedSchema((ResolvedSchema)this.getResolvedSchema());
    }

    public ResolvedSchema getResolvedSchema();

    public void printSchema();

    public QueryOperation getQueryOperation();

    public Table select(Expression ... var1);

    public TemporalTableFunction createTemporalTableFunction(Expression var1, Expression var2);

    public Table as(String var1, String ... var2);

    @Deprecated
    public Table as(Expression ... var1);

    public Table filter(Expression var1);

    public Table where(Expression var1);

    public GroupedTable groupBy(Expression ... var1);

    public Table distinct();

    public Table join(Table var1);

    public Table join(Table var1, Expression var2);

    public Table leftOuterJoin(Table var1);

    public Table leftOuterJoin(Table var1, Expression var2);

    public Table rightOuterJoin(Table var1, Expression var2);

    public Table fullOuterJoin(Table var1, Expression var2);

    public Table joinLateral(Expression var1);

    public Table joinLateral(Expression var1, Expression var2);

    public Table leftOuterJoinLateral(Expression var1);

    public Table leftOuterJoinLateral(Expression var1, Expression var2);

    public Table minus(Table var1);

    public Table minusAll(Table var1);

    public Table union(Table var1);

    public Table unionAll(Table var1);

    public Table intersect(Table var1);

    public Table intersectAll(Table var1);

    public Table orderBy(Expression ... var1);

    public Table offset(int var1);

    public Table fetch(int var1);

    default public Table limit(int fetch) {
        return this.fetch(fetch);
    }

    default public Table limit(int offset, int fetch) {
        return this.offset(offset).fetch(fetch);
    }

    public GroupWindowedTable window(GroupWindow var1);

    public OverWindowedTable window(OverWindow ... var1);

    public Table addColumns(Expression ... var1);

    public Table addOrReplaceColumns(Expression ... var1);

    public Table renameColumns(Expression ... var1);

    public Table dropColumns(Expression ... var1);

    public Table map(Expression var1);

    public Table flatMap(Expression var1);

    public AggregatedTable aggregate(Expression var1);

    public FlatAggregateTable flatAggregate(Expression var1);

    public TablePipeline insertInto(String var1);

    public TablePipeline insertInto(String var1, boolean var2);

    public TablePipeline insertInto(TableDescriptor var1);

    public TablePipeline insertInto(TableDescriptor var1, boolean var2);

    default public TableResult executeInsert(String tablePath) {
        return this.insertInto(tablePath).execute();
    }

    default public TableResult executeInsert(String tablePath, boolean overwrite) {
        return this.insertInto(tablePath, overwrite).execute();
    }

    default public TableResult executeInsert(TableDescriptor descriptor) {
        return this.insertInto(descriptor).execute();
    }

    default public TableResult executeInsert(TableDescriptor descriptor, boolean overwrite) {
        return this.insertInto(descriptor, overwrite).execute();
    }
}

