/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.operations.QueryOperation;

@Internal
public final class QueryOperationCatalogView
implements CatalogView {
    private final QueryOperation queryOperation;
    @Nullable
    private final CatalogView originalView;

    public QueryOperationCatalogView(QueryOperation queryOperation) {
        this(queryOperation, null);
    }

    public QueryOperationCatalogView(QueryOperation queryOperation, CatalogView originalView) {
        this.queryOperation = queryOperation;
        this.originalView = originalView;
    }

    public QueryOperation getQueryOperation() {
        return this.queryOperation;
    }

    public Schema getUnresolvedSchema() {
        return Optional.ofNullable(this.originalView).map(CatalogBaseTable::getUnresolvedSchema).orElseGet(() -> Schema.newBuilder().fromResolvedSchema(this.queryOperation.getResolvedSchema()).build());
    }

    public Map<String, String> getOptions() {
        if (this.originalView == null) {
            throw new TableException("A view backed by a query operation has no options.");
        }
        return this.originalView.getOptions();
    }

    public String getComment() {
        return Optional.ofNullable(this.originalView).map(CatalogBaseTable::getComment).orElseGet(this.queryOperation::asSummaryString);
    }

    public QueryOperationCatalogView copy() {
        return new QueryOperationCatalogView(this.queryOperation, this.originalView);
    }

    public Optional<String> getDescription() {
        return Optional.of(this.getComment());
    }

    public Optional<String> getDetailedDescription() {
        return this.getDescription();
    }

    public String getOriginalQuery() {
        if (this.originalView == null) {
            throw new TableException("A view backed by a query operation has no serializable representation.");
        }
        return this.originalView.getOriginalQuery();
    }

    public String getExpandedQuery() {
        if (this.originalView == null) {
            throw new TableException("A view backed by a query operation has no serializable representation.");
        }
        return this.originalView.getExpandedQuery();
    }

    @Internal
    public boolean supportsShowCreateView() {
        return this.originalView != null;
    }
}

