/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.command;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.util.Preconditions;

@Internal
public class SetOperation
implements Operation {
    @Nullable
    private final String key;
    @Nullable
    private final String value;

    public SetOperation() {
        this.key = null;
        this.value = null;
    }

    public SetOperation(String key, String value) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.value = (String)Preconditions.checkNotNull((Object)value);
    }

    public Optional<String> getKey() {
        return Optional.ofNullable(this.key);
    }

    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public String asSummaryString() {
        if (this.key == null && this.value == null) {
            return "SET";
        }
        return String.format("SET %s=%s", this.key, this.value);
    }
}

