/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.OverWindowRange;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.resolver.LocalOverWindow;
import org.apache.flink.table.expressions.resolver.rules.ResolverRule;
import org.apache.flink.table.expressions.resolver.rules.RuleExpressionVisitor;
import org.apache.flink.table.expressions.utils.ApiExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
final class OverWindowResolverRule
implements ResolverRule {
    private static final WindowKindExtractor OVER_WINDOW_KIND_EXTRACTOR = new WindowKindExtractor();

    OverWindowResolverRule() {
    }

    @Override
    public List<Expression> apply(List<Expression> expression, ResolverRule.ResolutionContext context) {
        return expression.stream().map(expr -> (Expression)expr.accept((ExpressionVisitor)new ExpressionResolverVisitor(context))).collect(Collectors.toList());
    }

    private static class WindowKindExtractor
    extends ApiExpressionDefaultVisitor<WindowKind> {
        private WindowKindExtractor() {
        }

        @Override
        public WindowKind visit(ValueLiteralExpression valueLiteral) {
            LogicalType literalType = valueLiteral.getOutputDataType().getLogicalType();
            if (literalType.is(LogicalTypeRoot.BIGINT)) {
                return WindowKind.ROW;
            }
            if (literalType.is(LogicalTypeRoot.INTERVAL_DAY_TIME)) {
                return WindowKind.RANGE;
            }
            return valueLiteral.getValueAs(OverWindowRange.class).map(v -> {
                switch (v) {
                    case CURRENT_ROW: 
                    case UNBOUNDED_ROW: {
                        return WindowKind.ROW;
                    }
                    case CURRENT_RANGE: 
                    case UNBOUNDED_RANGE: {
                        return WindowKind.RANGE;
                    }
                }
                throw new IllegalArgumentException("Unexpected window range: " + v);
            }).orElseGet(() -> this.defaultMethod((Expression)valueLiteral));
        }

        @Override
        protected WindowKind defaultMethod(Expression expression) {
            throw new ValidationException("An over window expects literal or unbounded bounds for preceding.");
        }
    }

    private static enum WindowKind {
        ROW,
        RANGE;

    }

    private static class ExpressionResolverVisitor
    extends RuleExpressionVisitor<Expression> {
        ExpressionResolverVisitor(ResolverRule.ResolutionContext context) {
            super(context);
        }

        @Override
        public Expression visit(UnresolvedCallExpression unresolvedCall) {
            if (unresolvedCall.getFunctionDefinition() == BuiltInFunctionDefinitions.OVER) {
                List<Expression> children = unresolvedCall.getChildren();
                Expression alias = children.get(1);
                LocalOverWindow referenceWindow = this.resolutionContext.getOverWindow(alias).orElseThrow(() -> new ValidationException("Could not resolve over call."));
                Expression following = this.calculateOverWindowFollowing(referenceWindow);
                ArrayList<Expression> newArgs = new ArrayList<Expression>(Arrays.asList(children.get(0), referenceWindow.getOrderBy(), referenceWindow.getPreceding(), following));
                newArgs.addAll(referenceWindow.getPartitionBy());
                return unresolvedCall.replaceArgs(newArgs);
            }
            return unresolvedCall.replaceArgs(unresolvedCall.getChildren().stream().map(expr -> (Expression)expr.accept((ExpressionVisitor)this)).collect(Collectors.toList()));
        }

        private Expression calculateOverWindowFollowing(LocalOverWindow referenceWindow) {
            return referenceWindow.getFollowing().orElseGet(() -> {
                WindowKind kind = (WindowKind)((Object)((Object)referenceWindow.getPreceding().accept((ExpressionVisitor)OVER_WINDOW_KIND_EXTRACTOR)));
                if (kind == WindowKind.ROW) {
                    return ApiExpressionUtils.valueLiteral(OverWindowRange.CURRENT_ROW);
                }
                return ApiExpressionUtils.valueLiteral(OverWindowRange.CURRENT_RANGE);
            });
        }

        @Override
        protected Expression defaultMethod(Expression expression) {
            return expression;
        }
    }
}

