/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@Internal
public abstract class AbstractCatalogView
implements CatalogView {
    private final String originalQuery;
    private final String expandedQuery;
    private final TableSchema schema;
    private final Map<String, String> options;
    private final String comment;

    public AbstractCatalogView(String originalQuery, String expandedQuery, TableSchema schema, Map<String, String> options, String comment) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)originalQuery) ? 1 : 0) != 0, (Object)"originalQuery cannot be null or empty");
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)expandedQuery) ? 1 : 0) != 0, (Object)"expandedQuery cannot be null or empty");
        this.originalQuery = originalQuery;
        this.expandedQuery = expandedQuery;
        this.schema = (TableSchema)Preconditions.checkNotNull((Object)schema, (String)"schema cannot be null");
        this.options = (Map)Preconditions.checkNotNull(options, (String)"options cannot be null");
        this.comment = comment;
    }

    public String getOriginalQuery() {
        return this.originalQuery;
    }

    public String getExpandedQuery() {
        return this.expandedQuery;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public TableSchema getSchema() {
        return this.schema;
    }

    public String getComment() {
        return this.comment != null ? this.comment : "";
    }
}

