/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.ManagedTableFactory;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.util.StringUtils;

@Deprecated
@Internal
public class ManagedTableListener {
    private final ClassLoader classLoader;
    private final ReadableConfig config;

    public ManagedTableListener(ClassLoader classLoader, ReadableConfig config) {
        this.classLoader = classLoader;
        this.config = config;
    }

    public ResolvedCatalogBaseTable<?> notifyTableCreation(@Nullable Catalog catalog, ObjectIdentifier identifier, ResolvedCatalogBaseTable<?> table, boolean isTemporary, boolean ignoreIfExists) {
        if (ManagedTableListener.isManagedTable(catalog, table)) {
            ResolvedCatalogTable managedTable = this.enrichOptions(identifier, table, isTemporary);
            ManagedTableFactory.discoverManagedTableFactory((ClassLoader)this.classLoader).onCreateTable(this.createTableFactoryContext(identifier, managedTable, isTemporary), ignoreIfExists);
            return managedTable;
        }
        return table;
    }

    public void notifyTableDrop(@Nullable Catalog catalog, ObjectIdentifier identifier, ResolvedCatalogBaseTable<?> table, boolean isTemporary, boolean ignoreIfNotExists) {
        if (ManagedTableListener.isManagedTable(catalog, table)) {
            ManagedTableFactory.discoverManagedTableFactory((ClassLoader)this.classLoader).onDropTable(this.createTableFactoryContext(identifier, (ResolvedCatalogTable)table, isTemporary), ignoreIfNotExists);
        }
    }

    public Map<String, String> notifyTableCompaction(@Nullable Catalog catalog, ObjectIdentifier identifier, ResolvedCatalogBaseTable<?> table, CatalogPartitionSpec partitionSpec, boolean isTemporary) {
        if (ManagedTableListener.isManagedTable(catalog, table)) {
            if (RuntimeExecutionMode.STREAMING.equals(this.config.get(ExecutionOptions.RUNTIME_MODE))) {
                throw new ValidationException("Compact managed table only works under batch mode.");
            }
            return ManagedTableFactory.discoverManagedTableFactory((ClassLoader)this.classLoader).onCompactTable(this.createTableFactoryContext(identifier, (ResolvedCatalogTable)table, isTemporary), partitionSpec);
        }
        throw new ValidationException("Only managed table supports compaction");
    }

    public static boolean isManagedTable(@Nullable Catalog catalog, CatalogBaseTable table) {
        Map options;
        if (catalog == null || !catalog.supportsManagedTable()) {
            return false;
        }
        if (table.getTableKind() != CatalogBaseTable.TableKind.TABLE || !(table instanceof CatalogTable)) {
            return false;
        }
        try {
            options = table.getOptions();
        }
        catch (TableException ignore) {
            return false;
        }
        if (TableFactoryUtil.isLegacyConnectorOptions(catalog, (ReadableConfig)new Configuration(), true, ObjectIdentifier.of((String)"dummy_catalog", (String)"dummy_database", (String)"dummy_table"), (CatalogTable)table, true)) {
            return false;
        }
        if (!StringUtils.isNullOrWhitespaceOnly((String)((String)options.get(FactoryUtil.CONNECTOR.key())))) {
            return false;
        }
        if (table instanceof ResolvedCatalogBaseTable) {
            table = ((ResolvedCatalogBaseTable)table).getOrigin();
        }
        return !(table instanceof ConnectorCatalogTable);
    }

    private ResolvedCatalogTable enrichOptions(ObjectIdentifier identifier, ResolvedCatalogBaseTable<?> table, boolean isTemporary) {
        if (!(table instanceof ResolvedCatalogTable)) {
            throw new UnsupportedOperationException("Managed table only supports catalog table, unsupported table type: " + table.getClass());
        }
        ResolvedCatalogTable resolvedTable = (ResolvedCatalogTable)table;
        Map newOptions = ManagedTableFactory.discoverManagedTableFactory((ClassLoader)this.classLoader).enrichOptions(this.createTableFactoryContext(identifier, resolvedTable, isTemporary));
        return resolvedTable.copy(newOptions);
    }

    private DynamicTableFactory.Context createTableFactoryContext(ObjectIdentifier identifier, ResolvedCatalogTable table, boolean isTemporary) {
        return new FactoryUtil.DefaultDynamicTableContext(identifier, table, Collections.emptyMap(), this.config, this.classLoader, isTemporary);
    }
}

