/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import org.apache.flink.table.operations.ShowOperation;
import org.apache.flink.util.Preconditions;

public class ShowTablesOperation
implements ShowOperation {
    private final String catalogName;
    private final String databaseName;
    private final boolean useLike;
    private final boolean notLike;
    private final String likePattern;
    private final String preposition;

    public ShowTablesOperation() {
        this.catalogName = null;
        this.databaseName = null;
        this.likePattern = null;
        this.useLike = false;
        this.notLike = false;
        this.preposition = null;
    }

    public ShowTablesOperation(String likePattern, boolean useLike, boolean notLike) {
        this.catalogName = null;
        this.databaseName = null;
        this.likePattern = useLike ? (String)Preconditions.checkNotNull((Object)likePattern, (String)"Like pattern must not be null") : null;
        this.useLike = useLike;
        this.notLike = notLike;
        this.preposition = null;
    }

    public ShowTablesOperation(String catalogName, String databaseName, String likePattern, boolean useLike, boolean notLike, String preposition) {
        this.catalogName = (String)Preconditions.checkNotNull((Object)catalogName, (String)"Catalog name must not be null");
        this.databaseName = (String)Preconditions.checkNotNull((Object)databaseName, (String)"Database name must not be null");
        this.likePattern = useLike ? (String)Preconditions.checkNotNull((Object)likePattern, (String)"Like pattern must not be null") : null;
        this.useLike = useLike;
        this.notLike = notLike;
        this.preposition = (String)Preconditions.checkNotNull((Object)preposition, (String)"Preposition must not be null");
    }

    public String getLikePattern() {
        return this.likePattern;
    }

    public String getPreposition() {
        return this.preposition;
    }

    public boolean isUseLike() {
        return this.useLike;
    }

    public boolean isNotLike() {
        return this.notLike;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String asSummaryString() {
        StringBuilder builder = new StringBuilder().append("SHOW TABLES");
        if (this.preposition != null) {
            builder.append(String.format(" %s %s.%s", this.preposition, this.catalogName, this.databaseName));
        }
        if (this.useLike) {
            if (this.notLike) {
                builder.append(String.format(" %s LIKE %s", "NOT", this.likePattern));
            } else {
                builder.append(String.format(" LIKE %s", this.likePattern));
            }
        }
        return builder.toString();
    }
}

