/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.CollectResultProvider;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.ModifyOperationVisitor;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;

@Internal
public final class CollectModifyOperation
implements ModifyOperation {
    private static final AtomicInteger uniqueId = new AtomicInteger(0);
    private final ObjectIdentifier tableIdentifier;
    private final QueryOperation child;
    private CollectResultProvider resultProvider;

    public CollectModifyOperation(ObjectIdentifier tableIdentifier, QueryOperation child) {
        this.tableIdentifier = tableIdentifier;
        this.child = child;
    }

    public static int getUniqueId() {
        return uniqueId.incrementAndGet();
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public void setSelectResultProvider(CollectResultProvider resultProvider) {
        this.resultProvider = resultProvider;
    }

    public CollectResultProvider getSelectResultProvider() {
        return this.resultProvider;
    }

    @Override
    public QueryOperation getChild() {
        return this.child;
    }

    @Override
    public <T> T accept(ModifyOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String asSummaryString() {
        return OperationUtils.formatWithChildren("CollectSink", Collections.singletonMap("identifier", this.tableIdentifier), Collections.singletonList(this.child), Operation::asSummaryString);
    }
}

