/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class CatalogQueryOperation
implements QueryOperation {
    private final ObjectIdentifier tableIdentifier;
    private final ResolvedSchema resolvedSchema;

    public CatalogQueryOperation(ObjectIdentifier tableIdentifier, ResolvedSchema resolvedSchema) {
        this.tableIdentifier = tableIdentifier;
        this.resolvedSchema = resolvedSchema;
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("identifier", this.tableIdentifier);
        args.put("fields", this.resolvedSchema.getColumnNames());
        return OperationUtils.formatWithChildren("CatalogTable", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

