/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ApiExpression;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.LookupCallExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionDefaultVisitor;

@Internal
public class LookupCallResolver
extends ApiExpressionDefaultVisitor<Expression> {
    private final FunctionLookup functionLookup;

    public LookupCallResolver(FunctionLookup functionLookup) {
        this.functionLookup = functionLookup;
    }

    @Override
    public Expression visit(LookupCallExpression lookupCall) {
        FunctionLookup.Result result = this.functionLookup.lookupFunction(lookupCall.getUnresolvedName()).orElseThrow(() -> new ValidationException("Undefined function: " + lookupCall.getUnresolvedName()));
        return ApiExpressionUtils.unresolvedCall(result.getFunctionIdentifier(), result.getFunctionDefinition(), this.resolveChildren(lookupCall.getChildren()));
    }

    @Override
    public Expression visit(UnresolvedCallExpression unresolvedCall) {
        return unresolvedCall.replaceArgs(this.resolveChildren(unresolvedCall.getChildren()));
    }

    private List<Expression> resolveChildren(List<Expression> lookupChildren) {
        return lookupChildren.stream().map(child -> (Expression)child.accept((ExpressionVisitor)this)).collect(Collectors.toList());
    }

    @Override
    public Expression visitNonApiExpression(Expression other) {
        if (other instanceof ApiExpression) {
            return (Expression)((ApiExpression)other).toExpr().accept((ExpressionVisitor)this);
        }
        return this.defaultMethod(other);
    }

    @Override
    protected Expression defaultMethod(Expression expression) {
        return expression;
    }
}

