/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.table.api.TableException;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

@Internal
class InsertResultIterator
implements CloseableIterator<Row> {
    private final JobClient jobClient;
    private final Row affectedRowCountsRow;
    private final ClassLoader classLoader;
    @Nullable
    private Boolean hasNext = null;

    InsertResultIterator(JobClient jobClient, Row affectedRowCountsRow, ClassLoader classLoader) {
        this.jobClient = jobClient;
        this.affectedRowCountsRow = affectedRowCountsRow;
        this.classLoader = classLoader;
    }

    public void close() throws Exception {
        this.jobClient.cancel();
    }

    public boolean hasNext() {
        if (this.hasNext == null) {
            try {
                this.jobClient.getJobExecutionResult().get();
            }
            catch (Exception e) {
                throw new TableException("Failed to wait job finish", (Throwable)e);
            }
            this.hasNext = true;
        }
        return this.hasNext;
    }

    public Row next() {
        if (this.hasNext()) {
            this.hasNext = false;
            return this.affectedRowCountsRow;
        }
        throw new NoSuchElementException();
    }
}

